/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.validation;

import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.bonitasoft.plugin.AbstractBuildMojo;
import org.bonitasoft.plugin.validation.ValidationException;
import org.bonitasoft.plugin.validation.uid.FragmentUidValidationTask;
import org.bonitasoft.plugin.validation.uid.PageUidValidationTask;
import org.bonitasoft.plugin.validation.uid.WidgetUidValidationTask;
import org.bonitasoft.plugin.validation.xml.XmlValidationTask;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.ArtifactBuilderFactory;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE)
public class ValidateMojo
extends AbstractBuildMojo {
    private static final Logger log = LoggerFactory.getLogger(ValidateMojo.class);
    public static final String BDM_SOURCE_FILE_REGEX = "^bom.xml$";
    public static final String BDM_ACCESS_CONTROL_SOURCE_FILE_REGEX = "^bdm_access_control.xml$";
    public static final String ORGANIZATION_SOURCE_FILE_REGEX = "^.*\\.organization$";
    private static final URL APPLICATION_XSD_URL = ValidateMojo.class.getResource("/application.xsd");
    private static final URL PROFILE_XSD_URL = ValidateMojo.class.getResource("/profiles.xsd");
    private static final URL ORGANIZATION_XSD_URL = ValidateMojo.class.getResource("/organization.xsd");
    private static final URL BDM_XSD_URL = ValidateMojo.class.getResource("/bom.xsd");
    private static final URL BDM_ACCESS_CONTROL_XSD_URL = ValidateMojo.class.getResource("/bdm-access-control.xsd");
    private static final String APPLICATION_SOURCE_DIR = "applications/";
    private static final String PROFILE_SOURCE_DIR = "profiles/";
    private static final String ORGANIZATION_SOURCE_DIR = "organizations/";
    private static final String BDM_SOURCE_DIR = "./";
    private static final String BDM_ACCESS_CONTROL_SOURCE_DIR = "./";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeXmlValidation("XML validation on Applications", APPLICATION_XSD_URL, APPLICATION_SOURCE_DIR);
            this.executeXmlValidation("XML validation on Profiles", PROFILE_XSD_URL, PROFILE_SOURCE_DIR);
            this.executeXmlValidation("XML validation on Organizations", ORGANIZATION_XSD_URL, ORGANIZATION_SOURCE_DIR, ORGANIZATION_SOURCE_FILE_REGEX);
            this.executeXmlValidation("XML validation on BDM", BDM_XSD_URL, "./", BDM_SOURCE_FILE_REGEX);
            this.executeXmlValidation("XML validation on BDM Access Control", BDM_ACCESS_CONTROL_XSD_URL, "./", BDM_ACCESS_CONTROL_SOURCE_FILE_REGEX);
            this.executeUidValidation();
        }
        catch (ValidationException e) {
            throw new MojoFailureException("Project validation failed with the following error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void executeXmlValidation(String taskName, URL xsdUrl, String artifactsSourceDir) throws ValidationException {
        this.executeXmlValidation(taskName, xsdUrl, artifactsSourceDir, null);
    }

    private void executeXmlValidation(String taskName, URL xsdUrl, String artifactsSourceDir, String sourceFileRegex) throws ValidationException {
        new XmlValidationTask(taskName, xsdUrl, this.project.getBasedir().toPath().resolve(artifactsSourceDir), sourceFileRegex).validate();
    }

    private void executeUidValidation() throws ValidationException {
        String baseDirName = this.project.getBasedir().getName();
        if (!"app".equals(baseDirName)) {
            log.debug("Current project base dir [{}] is not the '{}' directory, skip UID validation", (Object)baseDirName, (Object)"app");
            return;
        }
        UiDesignerProperties uidWorkspaceProperties = this.uidWorkspaceProperties(this.outputDirectory.toPath());
        ArtifactBuilder uidArtifactBuilder = new ArtifactBuilderFactory(uidWorkspaceProperties).create();
        new PageUidValidationTask(uidArtifactBuilder, uidWorkspaceProperties.getWorkspace().getPages().getDir()).validate();
        new FragmentUidValidationTask(uidArtifactBuilder, uidWorkspaceProperties.getWorkspace().getFragments().getDir()).validate();
        new WidgetUidValidationTask(uidArtifactBuilder, uidWorkspaceProperties.getWorkspace().getWidgets().getDir()).validate();
    }
}

