/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.UiDesignerPropertiesBuilder;

public abstract class AbstractBuildMojo
extends AbstractMojo {
    private static final String FRAGMENTS_FOLDER_NAME = "fragmentsFolderName";
    private static final String WIDGETS_FOLDER_NAME = "widgetsFolderName";
    protected static final String PAGES_FOLDER_NAME = "pagesFolderName";
    protected static final String WORKSPACE_PATH = "workspacePath";
    protected static final String APP_FOLDER_NAME = "app";
    @Parameter(defaultValue="${project}", required=false, readonly=true)
    protected MavenProject project;
    @Parameter(property="uid.workspace")
    private Map<String, String> uidWorkspace;
    @Parameter(defaultValue="${project.build.directory}", property="outputDirectory")
    protected File outputDirectory;

    protected Map<String, String> uidWorkspace() {
        if (this.uidWorkspace == null) {
            this.uidWorkspace = new HashMap<String, String>();
        }
        if (this.project != null) {
            this.uidWorkspace.putIfAbsent(WORKSPACE_PATH, this.project.getBasedir().getAbsolutePath());
        }
        this.uidWorkspace.putIfAbsent(PAGES_FOLDER_NAME, "web_page");
        this.uidWorkspace.putIfAbsent(WIDGETS_FOLDER_NAME, "web_widgets");
        this.uidWorkspace.putIfAbsent(FRAGMENTS_FOLDER_NAME, "web_fragments");
        return this.uidWorkspace;
    }

    protected UiDesignerProperties uidWorkspaceProperties(Path outputDirectory) {
        Map<String, String> workspace = this.uidWorkspace();
        return new UiDesignerPropertiesBuilder().workspaceUidPath(outputDirectory.resolve("uid-tmp")).disableLiveBuild().experimental(false).workspacePath(Paths.get(workspace.get(WORKSPACE_PATH), new String[0])).pagesFolderName(workspace.get(PAGES_FOLDER_NAME)).widgetsFolderName(workspace.get(WIDGETS_FOLDER_NAME)).fragmentsFolderName(workspace.get(FRAGMENTS_FOLDER_NAME)).build();
    }

    static {
        System.setProperty("org.jboss.logging.provider", "slf4j");
        System.setProperty("org.slf4j.simpleLogger.log.org.hibernate", "off");
        System.setProperty("org.slf4j.simpleLogger.log.org.bonitasoft.web.designer.migration", "warn");
        System.setProperty("org.slf4j.simpleLogger.log.org.bonitasoft.web.designer.service", "warn");
    }
}

