/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.validation.uid;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.plugin.validation.ValidationErrorException;
import org.bonitasoft.plugin.validation.ValidationException;
import org.bonitasoft.plugin.validation.ValidationTask;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUidValidationTask
implements ValidationTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractUidValidationTask.class);
    private static final String UID_DIRECTORY_EXCLUDE_REGEX = "^(?:pb.*|.metadata)$";
    protected final ArtifactBuilder artifactBuilder;
    protected final Path artifactsSourceDir;

    @Override
    public void validate() throws ValidationException {
        List<String> uidArtifacts = this.getUidArtifacts();
        if (uidArtifacts.isEmpty()) {
            return;
        }
        log.info("Executing {}", (Object)this.getTaskName());
        for (String uidArtifact : uidArtifacts) {
            log.debug("Executing validation on UID artifact [{}]", (Object)uidArtifact);
            if (!this.getArtifactStatus(uidArtifact).isCompatible()) {
                throw new ValidationException("UID artifact '" + uidArtifact + "' is not valid");
            }
            log.info("UID artifact '{}' is valid", (Object)uidArtifact);
        }
    }

    protected abstract String getTaskName();

    protected abstract ArtifactStatusReport getArtifactStatus(String var1);

    protected List<String> getUidArtifacts() {
        List<String> list;
        block9: {
            if (!Files.exists(this.artifactsSourceDir, new LinkOption[0]) || !Files.isDirectory(this.artifactsSourceDir, new LinkOption[0])) {
                log.debug("Artifacts source directory [{}] does not exist or is not a directory", (Object)this.artifactsSourceDir);
                return Collections.emptyList();
            }
            Stream<Path> sourcePaths = Files.list(this.artifactsSourceDir);
            try {
                List<String> sourceFiles = sourcePaths.filter(AbstractUidValidationTask::isUidArtifact).map(Path::getFileName).map(Path::toString).sorted().collect(Collectors.toList());
                log.debug("Found [{}] UID artifacts in directory [{}] for task {}", new Object[]{sourceFiles.size(), this.artifactsSourceDir, this.getTaskName()});
                list = sourceFiles;
                if (sourcePaths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sourcePaths != null) {
                        try {
                            sourcePaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ValidationErrorException("[" + this.getTaskName() + "] Failed to list UID artifacts in directory " + this.artifactsSourceDir, e);
                }
            }
            sourcePaths.close();
        }
        return list;
    }

    protected static boolean isUidArtifact(Path directory) throws ValidationErrorException {
        String directoryName = directory.getFileName().toString();
        if (Files.exists(directory, new LinkOption[0]) && Files.isDirectory(directory, new LinkOption[0]) && !directoryName.matches(UID_DIRECTORY_EXCLUDE_REGEX)) {
            boolean bl;
            block9: {
                Stream<Path> directoryEntries = Files.list(directory);
                try {
                    String expectedJson = directoryName + ".json";
                    boolean bl2 = bl = directoryEntries.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> expectedJson.equals(file.getFileName().toString())).count() == 1L;
                    if (directoryEntries == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (directoryEntries != null) {
                            try {
                                directoryEntries.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ValidationErrorException("An error occurred when listing files in directory " + directory, e);
                    }
                }
                directoryEntries.close();
            }
            return bl;
        }
        return false;
    }

    public AbstractUidValidationTask(ArtifactBuilder artifactBuilder, Path artifactsSourceDir) {
        this.artifactBuilder = artifactBuilder;
        this.artifactsSourceDir = artifactsSourceDir;
    }
}

