/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.MavenExecutor;

public class MavenSessionExecutor
implements MavenExecutor {
    private MavenSession session;

    private MavenSessionExecutor(MavenSession session) {
        this.session = session;
    }

    public void execute(File pomFile, List<String> goals, Map<String, String> properties, List<String> activeProfiles, Supplier<String> errorMessageBase) throws BuildBarException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pomFile);
        request.addArgs(goals);
        Stream<String> propArguments = properties.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue());
        request.addArgs(propArguments.toList());
        request.setBaseDirectory(pomFile.getParentFile());
        request.setQuiet(true);
        this.session.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> MavenSessionExecutor.lambda$execute$1(properties, (InvocationRequest)request, arg_0, arg_1)));
        request.setGlobalSettingsFile(this.session.getRequest().getGlobalSettingsFile());
        request.setUserSettingsFile(this.session.getRequest().getUserSettingsFile());
        request.setLocalRepositoryDirectory(this.session.getRequest().getLocalRepositoryPath());
        HashSet<String> profiles = new HashSet<String>(activeProfiles);
        profiles.addAll(this.session.getRequest().getActiveProfiles());
        request.setProfiles(new ArrayList<String>(profiles));
        try (ByteArrayOutputStream errStream = new ByteArrayOutputStream();
             PrintStream errPrintStream = new PrintStream(errStream);){
            PrintStreamHandler errHandler = new PrintStreamHandler(errPrintStream, false);
            request.setErrorHandler((InvocationOutputHandler)errHandler);
            try {
                DefaultInvoker invoker = new DefaultInvoker();
                InvocationResult result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    this.throwBuildBarException(errorMessageBase, errStream, (Exception)result.getExecutionException());
                }
            }
            catch (MavenInvocationException e2) {
                this.throwBuildBarException(errorMessageBase, errStream, (Exception)((Object)e2));
            }
        }
        catch (IOException e3) {
            throw new BuildBarException(errorMessageBase.get(), (Throwable)e3);
        }
    }

    private void throwBuildBarException(Supplier<String> errorMessageBase, ByteArrayOutputStream errorStream, Exception exception) throws BuildBarException, IOException {
        StringBuffer msg = new StringBuffer(errorMessageBase.get());
        errorStream.flush();
        String fromStream = errorStream.toString();
        Optional.ofNullable(fromStream).filter(StringUtils::isNotBlank).ifPresent(s -> msg.append("\n" + s));
        throw new BuildBarException(msg.toString(), (Throwable)exception);
    }

    public static MavenSessionExecutor fromSession(MavenSession session) {
        return new MavenSessionExecutor(session);
    }

    private static /* synthetic */ void lambda$execute$1(Map properties, InvocationRequest request, Object key, Object value) {
        if (!properties.containsKey(key)) {
            request.addArg("-D" + String.valueOf(key) + "=" + String.valueOf(value));
        }
    }
}

