/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bonitasoft.plugin.analyze.handler.ArtifactAnalyzerHandler;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;

public abstract class AbstractArtifactAnalyzerHandler
implements ArtifactAnalyzerHandler {
    private LocalRepositoryManager localRepositoryManager;

    AbstractArtifactAnalyzerHandler(LocalRepositoryManager localRepositoryManager) {
        this.localRepositoryManager = localRepositoryManager;
    }

    protected org.bonitasoft.plugin.analyze.report.model.Artifact create(org.apache.maven.artifact.Artifact artifact) {
        return org.bonitasoft.plugin.analyze.report.model.Artifact.create((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)(artifact.getBaseVersion() == null ? artifact.getVersion() : artifact.getBaseVersion()), (String)artifact.getClassifier(), (String)this.artifactLocalRepositoryFile(artifact));
    }

    protected String artifactLocalRepositoryFile(org.apache.maven.artifact.Artifact artifact) {
        String artifactPath = this.localRepositoryManager.getPathForLocalArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getBaseVersion() == null ? artifact.getVersion() : artifact.getBaseVersion()));
        Path localRepositoryPath = this.localRepositoryManager.getRepository().getBasedir().toPath();
        return localRepositoryPath.resolve(artifactPath).toAbsolutePath().toString();
    }

    protected Optional<ZipEntry> findZipEntry(File file, Predicate<ZipEntry> entryPredicate) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Optional<ZipEntry> optional = zipFile.stream().map(ZipEntry.class::cast).filter(entryPredicate).findFirst();
            return optional;
        }
    }
}

