/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.bonitasoft.plugin.analyze.handler.CustomPageAnalyzer;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.eclipse.aether.repository.LocalRepositoryManager;

class CustomPageProjectAnalyzer
extends CustomPageAnalyzer {
    private static final String CUSTOMPAGE_DESCRIPTOR_PROPERTIES = "page.properties";
    private MavenResourcesFiltering mavenResourcesFiltering;
    private List<MavenProject> reactorProjects;

    CustomPageProjectAnalyzer(LocalRepositoryManager localRepositoryManager, MavenResourcesFiltering mavenResourcesFiltering, List<MavenProject> reactorProjects) {
        super(localRepositoryManager);
        this.mavenResourcesFiltering = mavenResourcesFiltering;
        this.reactorProjects = reactorProjects;
    }

    @Override
    public boolean appliesTo(Artifact artifact) {
        File basedir = artifact.getFile();
        Path pageDescriptor = this.findCustomPageDescriptor(basedir);
        return Files.exists(pageDescriptor, new LinkOption[0]);
    }

    private Path findCustomPageDescriptor(File basedir) {
        Path pageDescriptor = basedir.toPath().resolve(CUSTOMPAGE_DESCRIPTOR_PROPERTIES);
        if (!Files.exists(pageDescriptor, new LinkOption[0])) {
            pageDescriptor = basedir.toPath().resolve("src/main/resources").resolve(CUSTOMPAGE_DESCRIPTOR_PROPERTIES);
        }
        return pageDescriptor;
    }

    @Override
    public DependencyReport analyze(Artifact artifact, DependencyReport report) throws IOException {
        Path filteredPageDescriptor = this.filterPageDescriptor(artifact.getFile(), this.findCustomPageDescriptor(artifact.getFile()));
        Properties properties = this.readPageProperties(filteredPageDescriptor);
        this.analyzeCustomPageArtifact(artifact, properties, report);
        return report;
    }

    private Path filterPageDescriptor(File basedir, Path pageDescriptor) throws IOException {
        Resource mavenResource = this.newFilteredResource(pageDescriptor);
        MavenResourcesExecution mavenResourcesExecution = this.newMavenResourcesExecution(mavenResource, basedir);
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new IOException(e);
        }
        return mavenResourcesExecution.getOutputDirectory().toPath().resolve(CUSTOMPAGE_DESCRIPTOR_PROPERTIES);
    }

    private MavenResourcesExecution newMavenResourcesExecution(Resource resource, File basedir) {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setResources(List.of(resource));
        MavenProject mavenProject = this.reactorProjects.stream().filter(p -> Objects.equals(basedir, p.getBasedir())).findFirst().orElseThrow();
        mavenResourcesExecution.setMavenProject(mavenProject);
        File outputFolder = new File(mavenProject.getBuild().getDirectory());
        mavenResourcesExecution.setOutputDirectory(outputFolder);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        mavenResourcesExecution.setFilterWrappers(List.of());
        mavenResourcesExecution.setEncoding("UTF-8");
        mavenResourcesExecution.setPropertiesEncoding("UTF-8");
        return mavenResourcesExecution;
    }

    private Resource newFilteredResource(Path pageDescriptor) {
        Resource mavenResource = new Resource();
        mavenResource.setDirectory(pageDescriptor.getParent().toString());
        mavenResource.setIncludes(List.of(pageDescriptor.getFileName().toString()));
        mavenResource.setFiltering(true);
        return mavenResource;
    }

    Properties readPageProperties(Path pageDescriptor) throws IOException {
        try {
            Properties properties;
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(pageDescriptor.toFile()), StandardCharsets.UTF_8);){
                Properties prop = new Properties();
                prop.load(in);
                properties = prop;
            }
            return properties;
        }
        finally {
            Files.delete(pageDescriptor);
        }
    }
}

