/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.MavenExecutor;

public class MavenSessionExecutor {
    private MavenSession session;

    private MavenSessionExecutor(MavenSession session) {
        this.session = session;
    }

    public void execute(File pomFile, File rootModuleDirectory, List<String> goals, Map<String, String> properties, List<String> activeProfiles, Supplier<String> errorMessageBase) throws BuildException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pomFile);
        request.addArgs(goals);
        Stream<String> propArguments = properties.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue());
        request.addArgs(propArguments.toList());
        request.setBaseDirectory(pomFile.getParentFile());
        request.setQuiet(true);
        request.setBatchMode(true);
        this.session.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> MavenSessionExecutor.lambda$execute$1(properties, (InvocationRequest)request, arg_0, arg_1)));
        request.setGlobalSettingsFile(this.session.getRequest().getGlobalSettingsFile());
        request.setUserSettingsFile(this.session.getRequest().getUserSettingsFile());
        request.setLocalRepositoryDirectory(this.session.getRequest().getLocalRepositoryPath());
        HashSet<String> profiles = new HashSet<String>(activeProfiles);
        profiles.addAll(this.session.getRequest().getActiveProfiles());
        request.setProfiles(new ArrayList<String>(profiles));
        try (ByteArrayOutputStream errStream = new ByteArrayOutputStream();
             PrintStream errPrintStream = new PrintStream(errStream);){
            PrintStreamHandler errHandler = new PrintStreamHandler(errPrintStream, false);
            request.setErrorHandler((InvocationOutputHandler)errHandler);
            this.invokeMaven(rootModuleDirectory, errorMessageBase, (InvocationRequest)request, errStream, errPrintStream);
        }
        catch (IOException e2) {
            throw new BuildException(errorMessageBase.get(), e2);
        }
    }

    private void invokeMaven(File rootModuleDirectory, Supplier<String> errorMessageBase, InvocationRequest request, ByteArrayOutputStream errStream, PrintStream errPrintStream) throws BuildException, IOException {
        try {
            String mvnHome = Optional.ofNullable(System.getProperty("maven.home")).orElse("");
            if (mvnHome.endsWith("\\EMBEDDED") || mvnHome.endsWith("/EMBEDDED")) {
                String msg = "Embedded maven home.";
                throw new MavenInvocationException(msg, (Throwable)new CommandLineConfigurationException(msg));
            }
            DefaultInvoker invoker = new DefaultInvoker();
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                this.throwBuildException(errorMessageBase, errStream, (Exception)result.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            if (e.getCause() instanceof CommandLineConfigurationException) {
                this.invokeMavenCli(rootModuleDirectory, errorMessageBase, request, errStream, errPrintStream);
            }
            this.throwBuildException(errorMessageBase, errStream, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMavenCli(File rootModuleDirectory, Supplier<String> errorMessageBase, InvocationRequest request, ByteArrayOutputStream errStream, PrintStream errPrintStream) throws BuildException, IOException {
        MavenCli cli = new MavenCli(this.session.getContainer().getContainerRealm().getWorld());
        String oldMultimoduleProjectProperty = System.getProperty("maven.multiModuleProjectDirectory");
        try {
            System.setProperty("maven.multiModuleProjectDirectory", rootModuleDirectory.toURI().toString());
            int exitCode = cli.doMain((String[])request.getArgs().toArray(String[]::new), request.getBaseDirectory().getAbsolutePath(), null, errPrintStream);
            if (exitCode != 0) {
                this.throwBuildException(errorMessageBase, errStream, null);
            }
        }
        finally {
            if (oldMultimoduleProjectProperty == null) {
                System.clearProperty("maven.multiModuleProjectDirectory");
            } else {
                System.setProperty("maven.multiModuleProjectDirectory", oldMultimoduleProjectProperty);
            }
        }
    }

    private void throwBuildException(Supplier<String> errorMessageBase, ByteArrayOutputStream errorStream, Exception exception) throws BuildException, IOException {
        StringBuffer msg = new StringBuffer(errorMessageBase.get());
        errorStream.flush();
        String fromStream = errorStream.toString();
        Optional.ofNullable(fromStream).filter(StringUtils::isNotBlank).ifPresent(s -> msg.append("\n" + s));
        throw new BuildException(msg.toString(), exception);
    }

    public static MavenSessionExecutor fromSession(MavenSession session) {
        return new MavenSessionExecutor(session);
    }

    public static MavenExecutor forBarFromSession(MavenSession session) {
        MavenSessionExecutor executor = MavenSessionExecutor.fromSession(session);
        return (pomFile, goals, properties, activeProfiles, errorMessageBase) -> {
            try {
                File rootModule = pomFile.getParentFile().getParentFile();
                executor.execute(pomFile, rootModule, goals, properties, activeProfiles, errorMessageBase);
            }
            catch (BuildException e) {
                throw new BuildBarException((String)errorMessageBase.get(), (Throwable)e);
            }
        };
    }

    private static /* synthetic */ void lambda$execute$1(Map properties, InvocationRequest request, Object key, Object value) {
        if (!properties.containsKey(key)) {
            request.addArg("-D" + String.valueOf(key) + "=" + String.valueOf(value));
        }
    }

    public static final class BuildException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BuildException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

