/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.bonitasoft.plugin.analyze.ArtifactAnalyzer;
import org.bonitasoft.plugin.analyze.ArtifactAnalyzerFactory;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.DefaultArtifactAnalyzer;
import org.bonitasoft.plugin.analyze.handler.ArtifactAnalyzerHandler;
import org.eclipse.aether.repository.LocalRepositoryManager;

@Named
@Singleton
class DefaultArtifactAnalyzerFactory
implements ArtifactAnalyzerFactory {
    private ConnectorResolver connectorResolver;
    private MavenResourcesFiltering mavenResourcesFiltering;

    @Inject
    public DefaultArtifactAnalyzerFactory(ConnectorResolver connectorResolver, MavenResourcesFiltering mavenResourcesFiltering) {
        this.connectorResolver = connectorResolver;
        this.mavenResourcesFiltering = mavenResourcesFiltering;
    }

    @Override
    public ArtifactAnalyzer create(LocalRepositoryManager localRepositoryManager, List<MavenProject> reactorProjects) {
        return new DefaultArtifactAnalyzer(ArtifactAnalyzerHandler.create(this.connectorResolver, localRepositoryManager, this.mavenResourcesFiltering, reactorProjects));
    }
}

