/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.content;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;
import org.slf4j.LoggerFactory;

public class ProjectArtifactContentReader
implements ArtifactContentReader {
    private MavenResourcesFiltering mavenResourcesFiltering;
    private List<MavenProject> reactorProjects;

    public ProjectArtifactContentReader(MavenResourcesFiltering mavenResourcesFiltering, List<MavenProject> reactorProjects) {
        this.mavenResourcesFiltering = mavenResourcesFiltering;
        this.reactorProjects = reactorProjects;
    }

    @Override
    public ArtifactContentReader.ArtifactFileType getArtifactFileType() {
        return ArtifactContentReader.ArtifactFileType.PROJECT_FOLDER;
    }

    @Override
    public boolean hasEntryWithPath(Artifact artifact, Path entryPath) {
        File baseDir = artifact.getFile();
        Path targetPath = baseDir.toPath().resolve(entryPath);
        return Files.exists(targetPath, new LinkOption[0]) && this.notInTargetDirectory(artifact).test(targetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readEntry(Artifact artifact, Path entryPath, Consumer<InputStream> reader) throws IllegalArgumentException, IOException {
        File baseDir = artifact.getFile();
        Path sourcePath = baseDir.toPath().resolve(entryPath);
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + String.valueOf(sourcePath) + " does not exist");
        }
        if (!this.notInTargetDirectory(artifact).test(sourcePath)) {
            throw new IllegalArgumentException("File " + String.valueOf(sourcePath) + " is in target build directory");
        }
        Path filteredDescriptor = this.filterDescriptor(baseDir, sourcePath);
        try (InputStream is = Files.newInputStream(filteredDescriptor, new OpenOption[0]);){
            reader.accept(is);
        }
        finally {
            Files.deleteIfExists(filteredDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<T> readFirstEntry(Artifact artifact, Predicate<Path> predicateOnPath, Function<ArtifactContentReader.Entry, T> reader) throws IOException {
        File baseDir = artifact.getFile();
        UnaryOperator toRelative = baseDir.toPath()::relativize;
        Predicate<Path> notInTarget = this.notInTargetDirectory(artifact);
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attr) -> {
            if (attr.isRegularFile()) {
                return predicateOnPath.and(notInTarget).test((Path)toRelative.apply(path));
            }
            return false;
        };
        try (Stream<Path> pathsStream = Files.find(baseDir.toPath(), 10, matcher, new FileVisitOption[0]);){
            Optional<T> optional;
            Stream<EntryAndCleaner> entriesStream = pathsStream.map(sourcePath -> this.makeEntry(baseDir, (Path)sourcePath));
            Optional<EntryAndCleaner> firstEntry = entriesStream.findFirst();
            if (firstEntry.isEmpty()) {
                Optional optional2 = Optional.empty();
                return optional2;
            }
            EntryAndCleaner entry = firstEntry.get();
            try {
                optional = Optional.of(reader.apply(entry.entry));
            }
            catch (Throwable throwable) {
                entry.cleaner.close();
                throw throwable;
            }
            entry.cleaner.close();
            return optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, A> R readEntries(Artifact artifact, Predicate<Path> predicateOnPath, Collector<ArtifactContentReader.Entry, A, R> reader) throws IOException {
        File baseDir = artifact.getFile();
        UnaryOperator toRelative = baseDir.toPath()::relativize;
        Predicate<Path> notInTarget = this.notInTargetDirectory(artifact);
        BiPredicate<Path, BasicFileAttributes> matcher = (path, attr) -> {
            if (attr.isRegularFile()) {
                return predicateOnPath.and(notInTarget).test((Path)toRelative.apply(path));
            }
            return false;
        };
        try (Stream<Path> pathsStream = Files.find(baseDir.toPath(), 10, matcher, new FileVisitOption[0]);){
            R r;
            Stream<EntryAndCleaner> entriesStream = pathsStream.map(sourcePath -> this.makeEntry(baseDir, (Path)sourcePath));
            ArrayList closables = new ArrayList();
            try {
                r = entriesStream.map(entryWithCleaner -> {
                    closables.add(entryWithCleaner.cleaner);
                    return entryWithCleaner.entry;
                }).collect(reader);
            }
            catch (Throwable throwable) {
                for (Closeable closable : closables) {
                    closable.close();
                }
                throw throwable;
            }
            for (Closeable closable : closables) {
                closable.close();
            }
            return r;
        }
    }

    EntryAndCleaner makeEntry(File baseDir, Path sourcePath) {
        Path resolvedPathInTarget = sourcePath.getFileName();
        AtomicReference filteredDescriptorRef = new AtomicReference();
        ArtifactContentReader.Entry entry = new ArtifactContentReader.Entry(resolvedPathInTarget, () -> {
            try {
                Path filteredDescriptor = this.filterDescriptor(baseDir, sourcePath);
                filteredDescriptorRef.set(filteredDescriptor);
                return Files.newInputStream(filteredDescriptor, new OpenOption[0]);
            }
            catch (IOException e) {
                this.logIOException(e, baseDir, baseDir.toPath().relativize(sourcePath));
                return null;
            }
        });
        return new EntryAndCleaner(entry, () -> {
            Path path = (Path)filteredDescriptorRef.get();
            if (path != null) {
                Files.deleteIfExists(path);
            }
        });
    }

    Path filterDescriptor(File basedir, Path descriptor) throws IOException {
        Resource mavenResource = this.newFilteredResource(descriptor);
        MavenResourcesExecution mavenResourcesExecution = this.newMavenResourcesExecution(mavenResource, basedir);
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new IOException(e);
        }
        return mavenResourcesExecution.getOutputDirectory().toPath().resolve(descriptor.getFileName());
    }

    private MavenResourcesExecution newMavenResourcesExecution(Resource resource, File basedir) {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setResources(List.of(resource));
        MavenProject mavenProject = this.findMavenProject(basedir);
        mavenResourcesExecution.setMavenProject(mavenProject);
        File outputFolder = new File(mavenProject.getBuild().getDirectory());
        mavenResourcesExecution.setOutputDirectory(outputFolder);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        mavenResourcesExecution.setFilterWrappers(List.of());
        mavenResourcesExecution.setEncoding("UTF-8");
        mavenResourcesExecution.setPropertiesEncoding("UTF-8");
        return mavenResourcesExecution;
    }

    private Resource newFilteredResource(Path descriptor) {
        Resource mavenResource = new Resource();
        mavenResource.setDirectory(descriptor.getParent() != null ? descriptor.getParent().toString() : ".");
        mavenResource.setIncludes(List.of(descriptor.getFileName().toString()));
        mavenResource.setFiltering(true);
        return mavenResource;
    }

    @Override
    public Set<String> detectImplementationHierarchy(String className, Artifact artifact, Consumer<ClassNotFoundException> exceptionHandler) throws UnsupportedOperationException {
        File baseDir = artifact.getFile();
        MavenProject mavenProject = this.findMavenProject(baseDir);
        try {
            List classpathElements = mavenProject.getCompileClasspathElements();
            classpathElements.add(mavenProject.getBuild().getOutputDirectory());
            URL[] urls = (URL[])classpathElements.stream().map(elt -> {
                try {
                    return new File((String)elt).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LoggerFactory.getLogger(ArtifactContentReader.class).error("An error occured while loading implementation class {} from Maven project {}", new Object[]{className, baseDir, e});
                    return null;
                }
            }).filter(Objects::nonNull).toArray(URL[]::new);
            return this.detectImplementationHierarchyFromClasspath(className, exceptionHandler, urls);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            LoggerFactory.getLogger(ArtifactContentReader.class).error("An error occured while loading implementation class {} from Maven project {}", new Object[]{className, baseDir, e});
            return Set.of();
        }
    }

    MavenProject findMavenProject(File baseDir) {
        return this.reactorProjects.stream().filter(p -> Objects.equals(baseDir, p.getBasedir())).findFirst().orElseThrow();
    }

    private Predicate<Path> notInTargetDirectory(Artifact artifact) {
        File baseDir = artifact.getFile();
        MavenProject mavenProject = this.findMavenProject(baseDir);
        Path targetDir = baseDir.toPath().relativize(Path.of(mavenProject.getBuild().getDirectory(), new String[0]));
        return path -> !path.startsWith(targetDir);
    }

    private Set<String> detectImplementationHierarchyFromClasspath(String className, Consumer<ClassNotFoundException> exceptionHandler, URL[] classpathUrls) throws IOException {
        Set<String> set;
        URLClassLoader classLoader = new URLClassLoader(classpathUrls, this.getClass().getClassLoader());
        try {
            Class<?> clazz = classLoader.loadClass(className);
            List superClasses = ClassUtils.getAllSuperclasses(clazz);
            List interfaces = ClassUtils.getAllInterfaces(clazz);
            set = Stream.concat(superClasses.stream(), interfaces.stream()).map(Class::getName).collect(Collectors.toSet());
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                exceptionHandler.accept(e);
                return Set.of();
            }
        }
        classLoader.close();
        return set;
    }

    record EntryAndCleaner(ArtifactContentReader.Entry entry, Closeable cleaner) {
    }
}

