/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.content;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;

public class ZipArtifactContentReader
implements ArtifactContentReader {
    @Override
    public ArtifactContentReader.ArtifactFileType getArtifactFileType() {
        return ArtifactContentReader.ArtifactFileType.ZIP;
    }

    private Path toPath(ZipEntry zipEntry) {
        return Path.of(URI.create(zipEntry.getName()).toString(), new String[0]);
    }

    @Override
    public <T> Optional<T> readFirstEntry(Artifact artifact, Predicate<Path> predicateOnPath, Function<ArtifactContentReader.Entry, T> reader) throws IOException {
        File file = artifact.getFile();
        try (ZipFile zipFile = new ZipFile(file);){
            Stream<ZipEntry> zipEntriesStream = zipFile.stream().filter(zipEntry -> predicateOnPath.test(this.toPath((ZipEntry)zipEntry)));
            Optional<Object> optional = zipEntriesStream.findFirst().map(zipEntry -> {
                ArtifactContentReader.Entry entry = this.makeEntry(file, zipFile, (ZipEntry)zipEntry);
                return reader.apply(entry);
            });
            return optional;
        }
    }

    @Override
    public <R, A> R readEntries(Artifact artifact, Predicate<Path> predicateOnPath, Collector<ArtifactContentReader.Entry, A, R> reader) throws IOException {
        File file = artifact.getFile();
        try (ZipFile zipFile = new ZipFile(file);){
            Stream<ZipEntry> zipEntriesStream = zipFile.stream().filter(zipEntry -> predicateOnPath.test(this.toPath((ZipEntry)zipEntry)));
            Stream<ArtifactContentReader.Entry> entriesStream = zipEntriesStream.map(zipEntry -> this.makeEntry(file, zipFile, (ZipEntry)zipEntry));
            R r = entriesStream.collect(reader);
            return r;
        }
    }

    private ArtifactContentReader.Entry makeEntry(File file, ZipFile zipFile, ZipEntry zipEntry) {
        return new ArtifactContentReader.Entry(this.toPath(zipEntry), () -> {
            try {
                return zipFile.getInputStream(zipEntry);
            }
            catch (IOException e) {
                this.logIOException(e, file, this.toPath(zipEntry));
                return null;
            }
        });
    }

    @Override
    public Set<String> detectImplementationHierarchy(String className, Artifact artifact, Consumer<ClassNotFoundException> exceptionHandler) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot detect implementation hierarchy in a ZIP file");
    }
}

