/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.xml.bind.JAXBException;
import org.bonitasoft.engine.business.application.exporter.ApplicationNodeContainerConverter;
import org.bonitasoft.engine.business.application.xml.ApplicationNode;
import org.bonitasoft.engine.business.application.xml.ApplicationNodeContainer;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;
import org.bonitasoft.plugin.analyze.handler.AbstractArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.model.ApplicationDescriptor;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class ApplicationDescriptorAnalyzer
extends AbstractArtifactAnalyzerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDescriptorAnalyzer.class);
    private static final String APPLICATION_CLASSIFIER = "application";
    private static final Predicate<Path> IS_APPLICATION_XML = path -> path.getParent() != null && path.getParent().toString().equals("applications") && path.getFileName().toString().matches(".*\\.xml");
    private ApplicationNodeContainerConverter converter = new ApplicationNodeContainerConverter();

    ApplicationDescriptorAnalyzer(LocalRepositoryManager localRepositoryManager, ArtifactContentReader contentReader) {
        super(localRepositoryManager, contentReader);
    }

    @Override
    public boolean appliesTo(org.apache.maven.artifact.Artifact artifact) {
        return super.appliesTo(artifact) && Objects.equals(artifact.getClassifier(), APPLICATION_CLASSIFIER) && this.hasApplicationDescriptor(artifact);
    }

    @Override
    public DependencyReport analyze(org.apache.maven.artifact.Artifact artifact, DependencyReport report) throws IOException {
        Optional<ApplicationNode> descriptor = this.readApplicationDescriptor(artifact);
        descriptor.ifPresent(app -> report.addApplicationDescriptor(ApplicationDescriptor.create((String)app.getDisplayName(), (String)app.getVersion(), (String)app.getDescription(), (String)app.getProfile(), (String)app.getToken(), (Artifact)this.create(artifact))));
        return report;
    }

    Optional<ApplicationNode> readApplicationDescriptor(org.apache.maven.artifact.Artifact artifact) throws IOException {
        Optional<Optional> appDesc = this.getContentReader().readFirstEntry(artifact, IS_APPLICATION_XML, entry -> {
            Optional optional;
            block8: {
                InputStream is = entry.supplier().get();
                try {
                    ApplicationNodeContainer container = this.converter.unmarshallFromXML(is.readAllBytes());
                    optional = container.getApplications().stream().findFirst();
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | JAXBException | SAXException e) {
                        LOGGER.warn("Failed to parse {} for application descriptor", (Object)artifact, (Object)e);
                        return Optional.empty();
                    }
                }
                is.close();
            }
            return optional;
        });
        return appDesc.orElseThrow(() -> new IllegalArgumentException(String.format("No application descriptor found in %s", artifact.getFile())));
    }

    boolean hasApplicationDescriptor(org.apache.maven.artifact.Artifact artifact) {
        return this.getContentReader().hasEntryWithPath(artifact, IS_APPLICATION_XML);
    }
}

