/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.BarBuilderFactory;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.BuildResult;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.configuration.ParameterConfigurationExtractor;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.plugin.MavenSessionExecutor;
import org.bonitasoft.plugin.build.AbstractConfigurationArchiveMojo;

@Mojo(name="extract-configuration", aggregator=true, requiresProject=true)
public class ExtractConfigurationArchiveMojo
extends AbstractConfigurationArchiveMojo {
    protected ParameterConfigurationExtractor extractor = new ParameterConfigurationExtractor();
    @Parameter(property="parameters.withoutValue", defaultValue="false")
    protected boolean withoutParametersValue;
    @Parameter(property="parameters.overwrite", defaultValue="false")
    protected boolean overwrite;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path tmpFolder = this.getTempFolder();
        BarBuilder barBuilder = this.createBarBuilder(tmpFolder);
        Path confFile = tmpFolder.resolve("configuration.bconf");
        try {
            BuildResult result = barBuilder.buildConfiguration(this.environment.toLowerCase());
            result.writeBonitaConfigurationTo(confFile);
            if (!Files.exists(confFile, new LinkOption[0])) {
                return;
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to extract process configurations.", (Throwable)e);
        }
        File outputFile = new File(this.parametersFile);
        if (outputFile.exists() && !this.overwrite) {
            throw new MojoFailureException(String.format("%s already exists. Overwrite the existing parameters file setting parameters.overwrite property to true. ", outputFile));
        }
        try {
            Files.createDirectories(outputFile.toPath().getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        try {
            this.extractor.extract(confFile.toFile(), outputFile.getAbsolutePath(), this.withoutParametersValue);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        finally {
            try {
                Files.deleteIfExists(confFile);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"An error occured while deleting {}", (Throwable)e);
            }
        }
    }

    Path getTempFolder() throws MojoExecutionException {
        return this.getAppModuleBuildDir().toPath().resolve("extract-configuration-tmp");
    }

    BarBuilder createBarBuilder(Path tmpFolder) throws MojoExecutionException {
        ProcessRegistry processRegistry = ProcessRegistry.of(this.selectedProcFiles(), (MigrationPolicy)MigrationPolicy.ALWAYS_MIGRATE_POLICY);
        try {
            return BarBuilderFactory.create((BarBuilderFactory.BuildConfig)BarBuilderFactory.BuildConfig.builder().processRegistry(processRegistry).connectorImplementationRegistry(ConnectorImplementationRegistry.of(List.of())).allowEmptyFormMapping(true).includeParameters(false).mavenProject(this.findAppModuleProject()).mavenExecutor(MavenSessionExecutor.forBarFromSession(this.session)).formBuilder(id -> new byte[0]).workingDirectory(tmpFolder).build());
        }
        catch (BuildBarException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private List<Path> selectedProcFiles() throws MojoExecutionException {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet procFileSet = new FileSet();
        File appModuleBaesir = this.getAppModuleBaseDir();
        procFileSet.setDirectory(appModuleBaesir.toPath().toString());
        procFileSet.setIncludes(List.of("**/*.proc"));
        return Stream.of(fileSetManager.getIncludedFiles(procFileSet)).map(procFile -> appModuleBaesir.toPath().resolve((String)procFile)).collect(Collectors.toList());
    }
}

