/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build.bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.BarBuilderFactory;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.BuildResult;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.form.FormBuilder;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.plugin.AbstractBuildMojo;
import org.bonitasoft.plugin.MavenSessionExecutor;
import org.bonitasoft.plugin.analyze.report.DependencyReporter;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.build.page.BuildPageException;
import org.bonitasoft.plugin.build.page.UidArtifactBuilder;
import org.bonitasoft.plugin.build.page.UidArtifactBuilderFactory;
import org.bonitasoft.web.designer.config.UiDesignerProperties;

@Mojo(name="business-archive", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="analyze")
public class BuildBarMojo
extends AbstractBuildMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.proc"};
    @Parameter(defaultValue="local", property="bonita.environment")
    String environment;
    @Parameter(property="bonita.configurationFile")
    String configurationFileName;
    @Parameter(defaultValue="false", property="bonita.allowEmptyFormMapping")
    private boolean allowEmptyFormMapping;
    @Parameter(defaultValue="false", property="bonita.includeParameters")
    private boolean includeParameters = false;
    @Parameter(defaultValue="false", property="bonita.migrateIfNeeded")
    private boolean migrateIfNeeded;
    @Parameter(defaultValue="true", property="bonita.includeDependencyJars")
    private boolean includeDependencyJars;
    @Parameter(property="proc.includes")
    private String[] includes;
    @Parameter(property="proc.excludes")
    private String[] excludes;
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    @Inject
    public BuildBarMojo(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        BarBuilder barBuilder;
        Path outputFolder = this.outputDirectory.toPath();
        MigrationPolicy migrationPolicy = this.migrateIfNeeded ? MigrationPolicy.ALWAYS_MIGRATE_POLICY : MigrationPolicy.NEVER_MIGRATE_POLICY;
        ProcessRegistry processRegistry = ProcessRegistry.of(this.selectedProcFiles(), (MigrationPolicy)migrationPolicy);
        File reportFile = this.outputDirectory.toPath().resolve("bonita-dependencies.json").toFile();
        if (!reportFile.exists()) {
            throw new MojoExecutionException("Dependency report is missing");
        }
        if (this.allowEmptyFormMapping) {
            this.getLog().warn((CharSequence)"Empty form mapping is enabled. Processes without a form mapping will be unresolved after deployment.");
        }
        if (this.migrateIfNeeded) {
            this.getLog().warn((CharSequence)"Process migration is enabled. If a process is in an older model version than expected, a migration will be attempted.");
        }
        Path tmpFolder = outputFolder.resolve("business-archive-tmp");
        try {
            barBuilder = BarBuilderFactory.create((BarBuilderFactory.BuildConfig)BarBuilderFactory.BuildConfig.builder().processRegistry(processRegistry).connectorImplementationRegistry(this.getConnectorImplementationRegistry(reportFile)).allowEmptyFormMapping(this.allowEmptyFormMapping).includeParameters(this.includeParameters).mavenProject(this.project).mavenExecutor(MavenSessionExecutor.forBarFromSession(this.session)).formBuilder(this.createFormBuilder(this.uidWorkspaceProperties(outputFolder))).workingDirectory(tmpFolder).withDependencyJars(this.includeDependencyJars).build());
        }
        catch (BuildBarException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        for (Pool pool : processRegistry.getProcesses()) {
            try {
                BuildResult buildResult = barBuilder.build(pool, this.environment.toLowerCase());
                buildResult.writeBusinessArchivesTo(outputFolder.resolve("processes"));
                this.getLog().info((CharSequence)"");
            }
            catch (IOException | BuildBarException e) {
                throw new MojoFailureException(String.format("Failed to build %s (%s)", pool.getName(), pool.getVersion()), e);
            }
        }
        try {
            BuildResult aggregatedResult = barBuilder.getBuildResult();
            if (aggregatedResult != null && !aggregatedResult.getConfigurations().isEmpty()) {
                this.getLog().info((CharSequence)"Building Bonita Configuration archive...");
                Path bonitaConfigurationFile = this.outputDirectory.toPath().resolve(this.getConfigurationFileName(this.project));
                aggregatedResult.writeBonitaConfigurationTo(bonitaConfigurationFile);
                if (Files.exists(bonitaConfigurationFile, new LinkOption[0])) {
                    this.projectHelper.attachArtifact(this.project, "bconf", this.environment.toLowerCase(), bonitaConfigurationFile.toFile());
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    String getConfigurationFileName(MavenProject project) {
        if (this.configurationFileName == null) {
            return String.format("%s-%s-%s.bconf", project.getArtifactId(), project.getVersion(), this.environment.toLowerCase());
        }
        return this.configurationFileName;
    }

    ConnectorImplementationRegistry getConnectorImplementationRegistry(File reportFile) throws MojoExecutionException {
        DependencyReport dependencyReport = new DependencyReport();
        try {
            dependencyReport = (DependencyReport)DependencyReporter.OBJECT_MAPPER.readValue(reportFile, DependencyReport.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Dependency report is missing");
        }
        ArrayList implementations = new ArrayList();
        dependencyReport.getConnectorImplementations().stream().map(BuildBarMojo::toConnectorImplementationJar).forEach(implementations::add);
        dependencyReport.getFilterImplementations().stream().map(BuildBarMojo::toConnectorImplementationJar).forEach(implementations::add);
        return ConnectorImplementationRegistry.of(implementations);
    }

    private static ConnectorImplementationRegistry.ConnectorImplementationJar toConnectorImplementationJar(Implementation implementation) {
        return ConnectorImplementationRegistry.ConnectorImplementationJar.of((String)implementation.getImplementationId(), (String)implementation.getImplementationVersion(), (File)new File(implementation.getArtifact().getFile()), (String)implementation.getJarEntry());
    }

    private List<Path> selectedProcFiles() {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet procFileSet = new FileSet();
        procFileSet.setDirectory(this.project.getBasedir().toPath().toString());
        procFileSet.setIncludes(Arrays.asList(this.getIncludes()));
        procFileSet.setExcludes(Arrays.asList(this.getExcludes()));
        return Stream.of(fileSetManager.getIncludedFiles(procFileSet)).map(procFile -> this.project.getBasedir().toPath().resolve((String)procFile)).collect(Collectors.toList());
    }

    FormBuilder createFormBuilder(UiDesignerProperties uiDesignerProperties) {
        final UidArtifactBuilder artifactBuilder = UidArtifactBuilderFactory.create(uiDesignerProperties);
        return new FormBuilder(){

            public byte[] export(String formId) throws IOException {
                try {
                    return artifactBuilder.buildPage(formId);
                }
                catch (BuildPageException e) {
                    throw new IOException(String.format("Failed to build form %s", formId), e);
                }
            }
        };
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

