/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.bonitasoft.plugin.module.ModuleGenerationException;
import org.bonitasoft.plugin.module.ModuleGenerator;

public abstract class AbstractModuleGenerator
implements ModuleGenerator {
    protected ModelReader modelReader;
    protected ModelWriter modelWriter;

    protected AbstractModuleGenerator(ModelReader modelReader, ModelWriter modelWriter) {
        this.modelReader = modelReader;
        this.modelWriter = modelWriter;
    }

    public Path createModule(String projectId, Model parent, Path moduleFolder, String templateFileName, String moduleNameSuffix) throws ModuleGenerationException {
        Path modulePom = moduleFolder.resolve("pom.xml");
        modulePom.toFile().getParentFile().mkdirs();
        try (InputStream is = AbstractModuleGenerator.class.getResourceAsStream(templateFileName);
             OutputStream os = Files.newOutputStream(modulePom, new OpenOption[0]);){
            Model modelTemplate = this.modelReader.read(is, null);
            modelTemplate.setArtifactId(projectId + moduleNameSuffix);
            Parent parentModel = modelTemplate.getParent();
            parentModel.setGroupId(parent.getGroupId());
            parentModel.setArtifactId(parent.getArtifactId());
            parentModel.setVersion(parent.getVersion());
            this.modelWriter.write(os, null, modelTemplate);
        }
        catch (IOException e) {
            throw new ModuleGenerationException(String.format("Failed to write %s module pom.", moduleFolder.getFileName()), e);
        }
        return moduleFolder;
    }
}

