/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.content;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.maven.artifact.Artifact;
import org.slf4j.LoggerFactory;

public interface ArtifactContentReader {
    default public boolean appliesTo(Artifact artifact) {
        return this.getArtifactFileType().appliesTo(artifact);
    }

    public ArtifactFileType getArtifactFileType();

    default public Optional<Path> findEntry(Artifact artifact, Predicate<Path> predicateOnPath) {
        try {
            return this.readFirstEntry(artifact, predicateOnPath, entry -> entry.path);
        }
        catch (IOException e) {
            this.logIOException(e, artifact.getFile(), null);
            return Optional.empty();
        }
    }

    default public Optional<Path> findEntryWithName(Artifact artifact, String entryName) {
        return this.findEntry(artifact, path -> path.getFileName().toString().equals(entryName));
    }

    default public boolean hasEntryWithPath(Artifact artifact, Predicate<Path> predicateOnPath) {
        return this.findEntry(artifact, predicateOnPath).isPresent();
    }

    default public boolean hasEntryWithPath(Artifact artifact, Path entryPath) {
        return this.findEntry(artifact, path -> path.equals(entryPath)).isPresent();
    }

    public <T> Optional<T> readFirstEntry(Artifact var1, Predicate<Path> var2, Function<Entry, T> var3) throws IOException;

    default public void readEntry(Artifact artifact, Path entryPath, Consumer<InputStream> reader) throws IllegalArgumentException, IOException {
        Optional<Boolean> entryRead = this.readFirstEntry(artifact, entryPath::equals, entry -> {
            Boolean bl;
            block9: {
                InputStream is = entry.supplier().get();
                try {
                    if (is != null) {
                        reader.accept(is);
                    }
                    bl = is != null;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logIOException(e, artifact.getFile(), entryPath);
                        return Boolean.FALSE;
                    }
                }
                is.close();
            }
            return bl;
        });
        if (entryRead.isEmpty()) {
            throw new IllegalArgumentException("No entry found for path " + String.valueOf(entryPath));
        }
        if (Boolean.FALSE.equals(entryRead.get())) {
            throw new IllegalArgumentException("Entry reading failed for path " + String.valueOf(entryPath));
        }
    }

    public <R, A> R readEntries(Artifact var1, Predicate<Path> var2, Collector<Entry, A, R> var3) throws IOException;

    default public void readEntries(Artifact artifact, Predicate<Path> predicateOnPath, Consumer<Entry> reader) throws IOException {
        Collector<Entry, Void, Void> collector = Collector.of(() -> null, (v, entry) -> reader.accept((Entry)entry), (v1, v2) -> null, new Collector.Characteristics[0]);
        this.readEntries(artifact, predicateOnPath, collector);
    }

    default public void logIOException(IOException e, File file, Path entryPath) {
        if (entryPath == null) {
            LoggerFactory.getLogger(ArtifactContentReader.class).warn("An error occured while reading {}", (Object)file, (Object)e);
        } else {
            LoggerFactory.getLogger(ArtifactContentReader.class).warn("An error occured while reading {} (content at {} cannot be read)", new Object[]{file, entryPath, e});
        }
    }

    public Set<String> detectImplementationHierarchy(String var1, Artifact var2, Consumer<ClassNotFoundException> var3) throws UnsupportedOperationException;

    public static enum ArtifactFileType {
        JAR,
        ZIP,
        PROJECT_FOLDER;


        public boolean appliesTo(Artifact artifact) {
            File file = artifact.getFile();
            switch (this) {
                case JAR: {
                    return file.isFile() && file.getName().endsWith(".jar");
                }
                case ZIP: {
                    return file.isFile() && file.getName().endsWith(".zip");
                }
                case PROJECT_FOLDER: {
                    return file.isDirectory();
                }
            }
            return false;
        }
    }

    public record Entry(Path path, Supplier<InputStream> supplier) {
    }
}

