/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.content.JarArtifactContentReader;
import org.bonitasoft.plugin.analyze.content.ProjectArtifactContentReader;
import org.bonitasoft.plugin.analyze.content.ZipArtifactContentReader;
import org.bonitasoft.plugin.analyze.handler.ApplicationDescriptorAnalyzer;
import org.bonitasoft.plugin.analyze.handler.ConnectorAnalyzer;
import org.bonitasoft.plugin.analyze.handler.CustomPageAnalyzer;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.eclipse.aether.repository.LocalRepositoryManager;

public interface ArtifactAnalyzerHandler {
    public boolean appliesTo(Artifact var1);

    public DependencyReport analyze(Artifact var1, DependencyReport var2) throws IOException;

    public static List<ArtifactAnalyzerHandler> create(ConnectorResolver connectorResolver, LocalRepositoryManager localRepositoryManager, MavenResourcesFiltering mavenResourcesFiltering, List<MavenProject> reactorProjects) {
        return List.of(new ConnectorAnalyzer(localRepositoryManager, connectorResolver, new JarArtifactContentReader()), new ConnectorAnalyzer(localRepositoryManager, connectorResolver, new ProjectArtifactContentReader(mavenResourcesFiltering, reactorProjects)), new CustomPageAnalyzer(localRepositoryManager, new ZipArtifactContentReader()), new CustomPageAnalyzer(localRepositoryManager, new ProjectArtifactContentReader(mavenResourcesFiltering, reactorProjects)), new ApplicationDescriptorAnalyzer(localRepositoryManager, new ZipArtifactContentReader()));
    }
}

