/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bonitasoft.bonita2bar.configuration.ParametersConfigurationMerger;
import org.bonitasoft.plugin.build.AbstractConfigurationArchiveMojo;

@Mojo(name="merge-configuration", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, aggregator=true, requiresProject=true)
public class MergeConfigurationArchiveMojo
extends AbstractConfigurationArchiveMojo {
    protected ParametersConfigurationMerger merger = new ParametersConfigurationMerger();
    @Parameter(property="bonita.configurationFile")
    protected String bonitaConfiguration;
    @Parameter(property="parameters.skipMerge", defaultValue="false")
    protected boolean skipMergeParameters = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File confFile;
        if (this.skipMergeParameters) {
            this.getLog().info((CharSequence)"Skipped.");
            return;
        }
        File input = this.defaultInputFile();
        if (!input.exists()) {
            this.getLog().info((CharSequence)String.format("Skipped. %s parameters file not found.", input.getAbsolutePath()));
            return;
        }
        File file = confFile = this.bonitaConfiguration != null ? new File(this.bonitaConfiguration) : this.defaultConfigurationFile();
        if (confFile == null || !confFile.exists()) {
            this.getLog().warn((CharSequence)"Skipped. Bonita configuration archive does not exist.");
            return;
        }
        try {
            this.merger.merge(confFile, input, confFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private File defaultInputFile() throws MojoExecutionException {
        if (this.parametersFile.contains("${bonita.environment}")) {
            this.parametersFile = this.parametersFile.replace("${bonita.environment}", this.getEnvironment());
        }
        return new File(this.parametersFile);
    }
}

