/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.extension;

import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.plugin.extension.impl.ExtensionsModuleGeneratorImpl;
import org.bonitasoft.plugin.module.ModuleGenerationException;
import org.bonitasoft.plugin.module.ModuleGenerator;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="create-extensions-module", defaultPhase=LifecyclePhase.NONE)
public class CreateExtensionsModuleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(required=true, property="bonitaProjectId")
    protected String bonitaProjectId;
    private BuildContext buildContext;
    private ModuleGenerator moduleGenerator;

    @Inject
    public CreateExtensionsModuleMojo(ExtensionsModuleGeneratorImpl moduleGenerator, BuildContext buildContext) {
        this.moduleGenerator = moduleGenerator;
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"pom".equals(this.project.getPackaging()) || !Objects.equals(this.project.getArtifactId(), this.bonitaProjectId + "-parent")) {
            return;
        }
        this.getLog().info((CharSequence)"Creating extensions maven module...");
        try {
            this.moduleGenerator.create(this.bonitaProjectId, this.project);
            this.buildContext.refresh(this.project.getFile());
        }
        catch (ModuleGenerationException ioe) {
            throw new MojoFailureException("Error while creating the extensions module.", (Throwable)ioe);
        }
    }
}

