/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.connector;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DescriptorIdentifier;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.analyze.report.model.Issue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named
public class ConnectorResolverImpl
implements ConnectorResolver {
    private static final String CONNECTOR_TYPE = "org.bonitasoft.engine.connector.Connector";
    private static final String FILTER_TYPE = "org.bonitasoft.engine.filter.UserFilter";
    private static final String ABSTRACT_CONNECTOR_TYPE = "org.bonitasoft.engine.connector.AbstractConnector";
    private static final String ABSTRACT_FILTER_TYPE = "org.bonitasoft.engine.filter.AbstractUserFilter";
    private static final Set<String> FILTER_TYPES = Set.of("org.bonitasoft.engine.filter.UserFilter", "org.bonitasoft.engine.filter.AbstractUserFilter");
    private static final Set<String> CONNECTOR_TYPES = Set.of("org.bonitasoft.engine.connector.Connector", "org.bonitasoft.engine.connector.AbstractConnector");
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorResolverImpl.class);
    private static final String IMPLEMENTATION_EXTENSION = ".impl";
    private static final String DEFINITION_EXTENSION = ".def";
    private static final String IMPLEMENTATION_NS = "http://www.bonitasoft.org/ns/connector/implementation/6.0";
    private static final String DEFINITION_NS = "http://www.bonitasoft.org/ns/connector/definition/6.1";

    private static String readElement(Document document, String elementName) {
        String textContent = document.getElementsByTagName(elementName).item(0).getTextContent();
        if (textContent != null) {
            textContent = textContent.trim();
        }
        return textContent;
    }

    @Override
    public List<Implementation> findAllImplementations(org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, Issue.Collector issueCollector) throws IOException {
        return this.findImplementationDescriptors(artifact, reader, issueCollector).stream().map(resource -> {
            Document document = resource.getDocument();
            String className = ConnectorResolverImpl.readElement(document, "implementationClassname");
            String implementationId = ConnectorResolverImpl.readElement(document, "implementationId");
            String implementationVersion = ConnectorResolverImpl.readElement(document, "implementationVersion");
            String definitionId = ConnectorResolverImpl.readElement(document, "definitionId");
            String definitionVersion = ConnectorResolverImpl.readElement(document, "definitionVersion");
            Set<String> hierarchy = this.detectImplementationHierarchy(className, artifact, reader, resource.getPath(), issueCollector);
            if (!Collections.disjoint(hierarchy, CONNECTOR_TYPES)) {
                return ConnectorImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (Artifact)ConnectorResolverImpl.create(artifact), (String)resource.getPath());
            }
            if (!Collections.disjoint(hierarchy, FILTER_TYPES)) {
                return ActorFilterImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (Artifact)ConnectorResolverImpl.create(artifact), (String)resource.getPath());
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private static Artifact create(org.apache.maven.artifact.Artifact artifact) {
        return Artifact.create((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)(artifact.getBaseVersion() == null ? artifact.getVersion() : artifact.getBaseVersion()), (String)artifact.getClassifier(), (String)artifact.getFile().getAbsolutePath());
    }

    @Override
    public List<Definition> findAllDefinitions(org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, Issue.Collector issueCollector) throws IOException {
        return this.findDefinitionDescriptors(artifact, reader, issueCollector).stream().map(resource -> {
            Document document = resource.getDocument();
            String definitionId = ConnectorResolverImpl.readElement(document, "id");
            String definitionVersion = ConnectorResolverImpl.readElement(document, "version");
            return Definition.create((DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (Artifact)ConnectorResolverImpl.create(artifact), (String)resource.getPath());
        }).toList();
    }

    private List<DocumentResource> findImplementationDescriptors(org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, Issue.Collector issueCollector) throws IOException {
        return this.getDocumentResources(artifact, reader, IMPLEMENTATION_EXTENSION, IMPLEMENTATION_NS, issueCollector);
    }

    private List<DocumentResource> findDefinitionDescriptors(org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, Issue.Collector issueCollector) throws IOException {
        return this.getDocumentResources(artifact, reader, DEFINITION_EXTENSION, DEFINITION_NS, issueCollector);
    }

    private List<DocumentResource> getDocumentResources(org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, String extension, String namespace, Issue.Collector issueCollector) throws IOException {
        ArrayList<DocumentResource> result = new ArrayList<DocumentResource>();
        reader.readEntries(artifact, path -> path.getFileName().toString().endsWith(extension), entry -> {
            try (InputStream is = entry.supplier().get();){
                Document document = this.asXMLDocument(is, namespace);
                if (document != null) {
                    result.add(new DocumentResource(entry.path().toString(), document));
                } else {
                    issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s is not compliant with '%s' XML schema definition", entry.path(), namespace), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
                }
            }
            catch (ParserConfigurationException e) {
                LOGGER.error("Failed to parser connector descriptor", (Throwable)e);
            }
            catch (SAXException e) {
                issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s is not a valid XML file: %s", entry.path(), e.toString()), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read {} in {}.", new Object[]{entry.path(), artifact.getFile(), e});
            }
        });
        return result;
    }

    private Set<String> detectImplementationHierarchy(String className, org.apache.maven.artifact.Artifact artifact, ArtifactContentReader reader, String resourcePath, Issue.Collector issueCollector) {
        return reader.detectImplementationHierarchy(className, artifact, e -> {
            LOGGER.error("Failed to load class {} from jar {}", new Object[]{className, artifact.getFile(), e});
            issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s declares an unknown 'implementationClassname': %s", resourcePath, className), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
        });
    }

    private Document asXMLDocument(InputStream source, String namespace) throws ParserConfigurationException, SAXException, IOException {
        if (source != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(source));
            Node firstChild = document.getFirstChild();
            String namespaceURI = firstChild.getNamespaceURI();
            if (namespace.equals(namespaceURI)) {
                return document;
            }
        }
        return null;
    }

    public static class DocumentResource {
        private final String path;
        private final Document document;

        public DocumentResource(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String getPath() {
            return this.path;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

