/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.content;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.getopt.GetOptSinkFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;

public class JarArtifactContentReader
implements ArtifactContentReader {
    @Override
    public ArtifactContentReader.ArtifactFileType getArtifactFileType() {
        return ArtifactContentReader.ArtifactFileType.JAR;
    }

    private Path toPath(JarEntry jarEntry) {
        return Path.of(URI.create(jarEntry.getName()).toString(), new String[0]);
    }

    @Override
    public <T> Optional<T> readFirstEntry(Artifact artifact, Predicate<Path> predicateOnPath, Function<ArtifactContentReader.Entry, T> reader) throws IOException {
        File file = artifact.getFile();
        try (JarFile jarFile = new JarFile(file);){
            Stream<JarEntry> jarEntriesStream = jarFile.stream().filter(jarEntry -> predicateOnPath.test(this.toPath((JarEntry)jarEntry)));
            Optional<Object> optional = jarEntriesStream.findFirst().map(jarEntry -> {
                ArtifactContentReader.Entry entry = this.makeEntry(file, jarFile, (JarEntry)jarEntry);
                return reader.apply(entry);
            });
            return optional;
        }
    }

    @Override
    public <R, A> R readEntries(Artifact artifact, Predicate<Path> predicateOnPath, Collector<ArtifactContentReader.Entry, A, R> reader) throws IOException {
        File file = artifact.getFile();
        try (JarFile jarFile = new JarFile(file);){
            Stream<JarEntry> jarEntriesStream = jarFile.stream().filter(jarEntry -> predicateOnPath.test(this.toPath((JarEntry)jarEntry)));
            Stream<ArtifactContentReader.Entry> entriesStream = jarEntriesStream.map(jarEntry -> this.makeEntry(file, jarFile, (JarEntry)jarEntry));
            R r = entriesStream.collect(reader);
            return r;
        }
    }

    @Override
    public void readEntries(Artifact artifact, Predicate<Path> predicateOnPath, Consumer<ArtifactContentReader.Entry> reader) throws IOException {
        File file = artifact.getFile();
        try (JarFile jarFile = new JarFile(file);){
            Stream<JarEntry> entriesStream = jarFile.stream().filter(jarEntry -> predicateOnPath.test(this.toPath((JarEntry)jarEntry)));
            entriesStream.forEach(jarEntry -> {
                ArtifactContentReader.Entry entry = this.makeEntry(file, jarFile, (JarEntry)jarEntry);
                reader.accept(entry);
            });
        }
    }

    private ArtifactContentReader.Entry makeEntry(File file, JarFile jarFile, JarEntry jarEntry) {
        return new ArtifactContentReader.Entry(this.toPath(jarEntry), () -> {
            try {
                return jarFile.getInputStream(jarEntry);
            }
            catch (IOException e) {
                this.logIOException(e, file, this.toPath(jarEntry));
                return null;
            }
        });
    }

    @Override
    public Set<String> detectImplementationHierarchy(String className, Artifact artifact, Consumer<ClassNotFoundException> exceptionHandler) throws UnsupportedOperationException {
        HashSet<String> hierarchy = new HashSet<String>();
        File file = artifact.getFile();
        GetOptSinkFactory<Options> factory = OptionsImpl.getFactory();
        Options options = factory.create(Map.of());
        ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(options);
        classFileSource.informAnalysisRelativePathDetail(null, null);
        DCCommonState dcCommonState = new DCCommonState(options, classFileSource);
        TreeMap<Integer, List<JavaTypeInstance>> types = dcCommonState.explicitlyLoadJar(file.getAbsolutePath(), AnalysisType.JAR);
        try {
            ClassFile classFile = this.loadClassFile(dcCommonState, types, className);
            if (classFile != null) {
                classFile.getBindingSupers().getBoundSuperClasses().keySet().stream().map(JavaRefTypeInstance::getRawName).forEach(hierarchy::add);
            }
        }
        catch (ClassNotFoundException e) {
            exceptionHandler.accept(e);
        }
        return hierarchy;
    }

    private ClassFile loadClassFile(DCCommonState dcCommonState, Map<Integer, List<JavaTypeInstance>> loadedTypes, String className) throws ClassNotFoundException {
        return loadedTypes.values().stream().flatMap(Collection::stream).filter(type -> Objects.equals(className, type.toString())).map(dcCommonState::getClassFile).findFirst().orElseThrow(() -> new ClassNotFoundException(className));
    }
}

