/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.bonitasoft.plugin.analyze.content.ArtifactContentReader;
import org.bonitasoft.plugin.analyze.handler.AbstractArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.CustomPage;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Form;
import org.bonitasoft.plugin.analyze.report.model.Page;
import org.bonitasoft.plugin.analyze.report.model.RestAPIExtension;
import org.bonitasoft.plugin.analyze.report.model.Theme;
import org.eclipse.aether.repository.LocalRepositoryManager;

class CustomPageAnalyzer
extends AbstractArtifactAnalyzerHandler {
    private static final String CUSTOMPAGE_DESCRIPTOR_PROPERTIES = "page.properties";

    CustomPageAnalyzer(LocalRepositoryManager localRepositoryManager, ArtifactContentReader contentReader) {
        super(localRepositoryManager, contentReader);
    }

    @Override
    public boolean appliesTo(org.apache.maven.artifact.Artifact artifact) {
        return super.appliesTo(artifact) && this.hasCustomPageDescriptor(artifact);
    }

    @Override
    public DependencyReport analyze(org.apache.maven.artifact.Artifact artifact, DependencyReport report) throws IOException {
        Properties properties = this.readPageProperties(artifact);
        this.analyzeCustomPageArtifact(artifact, properties, report);
        return report;
    }

    Properties readPageProperties(org.apache.maven.artifact.Artifact artifact) throws IOException {
        Predicate<Path> isPageProperties = path -> path.getFileName().toString().equals(CUSTOMPAGE_DESCRIPTOR_PROPERTIES);
        Optional<Properties> result = this.getContentReader().readFirstEntry(artifact, isPageProperties, entry -> {
            Properties properties;
            InputStreamReader reader = new InputStreamReader(entry.supplier().get(), StandardCharsets.UTF_8);
            try {
                Properties prop = new Properties();
                prop.load(reader);
                properties = prop;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.getContentReader().logIOException(e, artifact.getFile(), entry.path());
                    return null;
                }
            }
            reader.close();
            return properties;
        });
        return result.filter(Objects::nonNull).orElseThrow(() -> new IllegalArgumentException(String.format("No page.properties found in %s", artifact.getFile())));
    }

    void analyzeCustomPageArtifact(org.apache.maven.artifact.Artifact artifact, Properties pageDescriptor, DependencyReport result) {
        String contentType = pageDescriptor.getProperty("contentType");
        CustomPage.CustomPageType customPageType = CustomPage.CustomPageType.valueOf((String)contentType.toUpperCase());
        String name = pageDescriptor.getProperty("name");
        String displayName = pageDescriptor.getProperty("displayName");
        String description = pageDescriptor.getProperty("description");
        switch (customPageType) {
            case FORM: {
                result.addForm(Form.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case PAGE: {
                result.addPage(Page.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case THEME: {
                result.addTheme(Theme.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case APIEXTENSION: {
                result.addRestAPIExtension(RestAPIExtension.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            default: {
                throw new AnalysisResultReportException("Unsupported Custom Page type: " + contentType);
            }
        }
    }

    boolean hasCustomPageDescriptor(org.apache.maven.artifact.Artifact artifact) {
        return this.getContentReader().findEntryWithName(artifact, CUSTOMPAGE_DESCRIPTOR_PROPERTIES).isPresent();
    }
}

