/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.bdm.codegen.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bonitasoft.engine.bdm.BusinessObjectModelConverter;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.plugin.bdm.codegen.BusinessDataModelParser;
import org.bonitasoft.plugin.bdm.codegen.ParseException;

@Singleton
@Named
public class BusinessDataModelParserImpl
implements BusinessDataModelParser {
    private BusinessObjectModelConverter converter = new BusinessObjectModelConverter();

    @Override
    public BusinessObjectModel parse(File modelFile) throws ParseException {
        File file = Objects.requireNonNull(modelFile, "modelFile cannot be null !");
        try {
            return this.converter.unmarshall(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new ParseException(String.format("Failed to parse %s.", modelFile), e);
        }
    }
}

