/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.validation.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lombok.Generated;
import org.bonitasoft.plugin.validation.ValidationErrorException;
import org.bonitasoft.plugin.validation.ValidationException;
import org.bonitasoft.plugin.validation.ValidationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlValidationTask
implements ValidationTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlValidationTask.class);
    protected static final String DEFAULT_TASK_NAME = "XML Validation Task";
    private static final String DEFAULT_SOURCE_FILE_REGEX = "^.*\\.xml$";
    private final String taskName;
    private final URL xsdUrl;
    private final Path artifactsSourceDir;
    private final String sourceFileRegex;

    public XmlValidationTask(String taskName, URL xsdUrl, Path artifactsSourceDir, String sourceFileRegex) {
        this.taskName = taskName;
        this.xsdUrl = xsdUrl;
        this.artifactsSourceDir = artifactsSourceDir;
        this.sourceFileRegex = sourceFileRegex == null ? DEFAULT_SOURCE_FILE_REGEX : sourceFileRegex;
    }

    public XmlValidationTask(String taskName, URL xsdUrl, Path artifactsSourceDir) {
        this(taskName, xsdUrl, artifactsSourceDir, DEFAULT_SOURCE_FILE_REGEX);
    }

    public XmlValidationTask(URL xsdUrl, Path artifactsSourceDir, String sourceFileRegex) {
        this(DEFAULT_TASK_NAME, xsdUrl, artifactsSourceDir, sourceFileRegex);
    }

    public XmlValidationTask(URL xsdUrl, Path artifactsSourceDir) {
        this(DEFAULT_TASK_NAME, xsdUrl, artifactsSourceDir);
    }

    @Override
    public void validate() throws ValidationException {
        List<File> sourceFiles = this.getSourceFiles();
        if (sourceFiles.isEmpty()) {
            return;
        }
        log.info("Executing {}", (Object)this.taskName);
        Validator validator = this.initValidator();
        for (File file : sourceFiles) {
            try {
                log.debug("Executing validation on file [{}]", (Object)file.getName());
                validator.validate(new StreamSource(file));
                log.info("File '{}' is valid", (Object)file.getName());
            }
            catch (Exception e) {
                throw new ValidationException("File '" + file.getName() + "' is not valid", e);
            }
        }
    }

    protected Validator initValidator() throws ValidationErrorException {
        log.debug("Initializing schema validator [{}]", (Object)this.xsdUrl);
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            sf.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            return sf.newSchema(this.xsdUrl).newValidator();
        }
        catch (Exception e) {
            throw new ValidationErrorException("[" + this.taskName + "] Failed to parse XSD with URL " + String.valueOf(this.xsdUrl), e);
        }
    }

    protected List<File> getSourceFiles() throws ValidationErrorException {
        List<File> list;
        block9: {
            if (!Files.exists(this.artifactsSourceDir, new LinkOption[0]) || !Files.isDirectory(this.artifactsSourceDir, new LinkOption[0])) {
                log.debug("Artifacts source directory [{}] does not exist or is not a directory", (Object)this.artifactsSourceDir);
                return Collections.emptyList();
            }
            Stream<Path> sourcePaths = Files.list(this.artifactsSourceDir);
            try {
                List<File> sourceFiles = sourcePaths.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().matches(this.sourceFileRegex)).map(Path::toFile).sorted().collect(Collectors.toList());
                log.debug("Found [{}] source files in directory [{}] matching regex [{}] for task [{}]", new Object[]{sourceFiles.size(), this.artifactsSourceDir, this.sourceFileRegex, this.taskName});
                list = sourceFiles;
                if (sourcePaths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sourcePaths != null) {
                        try {
                            sourcePaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ValidationErrorException("[" + this.taskName + "] Failed to list files in directory " + String.valueOf(this.artifactsSourceDir), e);
                }
            }
            sourcePaths.close();
        }
        return list;
    }
}

