/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.report.model;

import java.util.Arrays;
import java.util.List;

public class Issue {
    private String severity;
    private String type;
    private List<String> context;
    private String message;

    public static Issue create(Type type, String message, Severity severity, String ... context) {
        Issue issue = new Issue();
        issue.setType(type.name());
        issue.setSeverity(severity.name());
        issue.setMessage(message);
        issue.setContext(Arrays.asList(context));
        return issue;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getContext() {
        return this.context;
    }

    public String getMessage() {
        return this.message;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$context = this.getContext();
        List<String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Issue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "Issue(severity=" + this.getSeverity() + ", type=" + this.getType() + ", context=" + this.getContext() + ", message=" + this.getMessage() + ")";
    }

    public static enum Type {
        INCOMPATIBLE_DEPENDENCY;

    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

