/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.report.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.DescriptorIdentifier;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectorImplementation.class, name="CONNECTOR"), @JsonSubTypes.Type(value=ActorFilterImplementation.class, name="ACTOR_FILTER")})
public abstract class Implementation {
    private String className;
    private String implementationId;
    private String implementationVersion;
    private String definitionId;
    private String definitionVersion;
    private Artifact artifact;
    private String jarEntry;

    public static <T extends Implementation> T create(String className, DescriptorIdentifier definitionIdentifier, DescriptorIdentifier implementationIdentifier, Artifact artifact, String jarEntry, Class<T> type) {
        try {
            Implementation implementation = (Implementation)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            implementation.setClassName(className);
            implementation.setDefinitionId(definitionIdentifier.getId());
            implementation.setDefinitionVersion(definitionIdentifier.getVersion());
            implementation.setImplementationId(implementationIdentifier.getId());
            implementation.setImplementationVersion(implementationIdentifier.getVersion());
            implementation.setArtifact(artifact);
            implementation.setJarEntry(jarEntry);
            return (T)implementation;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create a new instance of class: " + type.getName(), e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getImplementationId() {
        return this.implementationId;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public String getDefinitionVersion() {
        return this.definitionVersion;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getJarEntry() {
        return this.jarEntry;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setImplementationId(String implementationId) {
        this.implementationId = implementationId;
    }

    public void setImplementationVersion(String implementationVersion) {
        this.implementationVersion = implementationVersion;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public void setDefinitionVersion(String definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public void setJarEntry(String jarEntry) {
        this.jarEntry = jarEntry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Implementation)) {
            return false;
        }
        Implementation other = (Implementation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$implementationId = this.getImplementationId();
        String other$implementationId = other.getImplementationId();
        if (this$implementationId == null ? other$implementationId != null : !this$implementationId.equals(other$implementationId)) {
            return false;
        }
        String this$implementationVersion = this.getImplementationVersion();
        String other$implementationVersion = other.getImplementationVersion();
        if (this$implementationVersion == null ? other$implementationVersion != null : !this$implementationVersion.equals(other$implementationVersion)) {
            return false;
        }
        String this$definitionId = this.getDefinitionId();
        String other$definitionId = other.getDefinitionId();
        if (this$definitionId == null ? other$definitionId != null : !this$definitionId.equals(other$definitionId)) {
            return false;
        }
        String this$definitionVersion = this.getDefinitionVersion();
        String other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        Artifact this$artifact = this.getArtifact();
        Artifact other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact)) {
            return false;
        }
        String this$jarEntry = this.getJarEntry();
        String other$jarEntry = other.getJarEntry();
        return !(this$jarEntry == null ? other$jarEntry != null : !this$jarEntry.equals(other$jarEntry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Implementation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $implementationId = this.getImplementationId();
        result = result * 59 + ($implementationId == null ? 43 : $implementationId.hashCode());
        String $implementationVersion = this.getImplementationVersion();
        result = result * 59 + ($implementationVersion == null ? 43 : $implementationVersion.hashCode());
        String $definitionId = this.getDefinitionId();
        result = result * 59 + ($definitionId == null ? 43 : $definitionId.hashCode());
        String $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        Artifact $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
        String $jarEntry = this.getJarEntry();
        result = result * 59 + ($jarEntry == null ? 43 : $jarEntry.hashCode());
        return result;
    }

    public String toString() {
        return "Implementation(className=" + this.getClassName() + ", implementationId=" + this.getImplementationId() + ", implementationVersion=" + this.getImplementationVersion() + ", definitionId=" + this.getDefinitionId() + ", definitionVersion=" + this.getDefinitionVersion() + ", artifact=" + this.getArtifact() + ", jarEntry=" + this.getJarEntry() + ")";
    }
}

