/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.report.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class Issue {
    private String severity;
    private String type;
    private List<String> context;
    private String message;

    public static Issue create(Type type, String message, Severity severity, String ... context) {
        Issue issue = new Issue();
        issue.setType(type.name());
        issue.setSeverity(severity.name());
        issue.setMessage(message);
        issue.setContext(Arrays.asList(context));
        return issue;
    }

    public static Collector collector() {
        return new Collector(){
            private List<Issue> issues = new ArrayList<Issue>();

            @Override
            public void addIssue(Issue issue) {
                this.issues.add(issue);
            }

            @Override
            public List<Issue> getIssues() {
                return this.issues;
            }
        };
    }

    @Generated
    public Issue() {
    }

    @Generated
    public String getSeverity() {
        return this.severity;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public List<String> getContext() {
        return this.context;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setContext(List<String> context) {
        this.context = context;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$context = this.getContext();
        List<String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Issue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Issue(severity=" + this.getSeverity() + ", type=" + this.getType() + ", context=" + String.valueOf(this.getContext()) + ", message=" + this.getMessage() + ")";
    }

    public static enum Type {
        INCOMPATIBLE_DEPENDENCY,
        INVALID_DESCRIPTOR_FILE,
        UNKNOWN_DEFINITION_TYPE;

    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }

    public static interface Collector {
        public void addIssue(Issue var1);

        public List<Issue> getIssues();
    }
}

