/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.studio.maven.plugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.bonitasoft.studio.maven.plugin.exception.CreateImageException;

public class SetImageVersion {
    protected static final String DEFAULT_FONT_NAME = "HelveticaNeueLTStd-Cn";
    private String baseImgPath;
    private String fontName;
    private String fontResourcePath;
    private String versionLabel;
    private String buildId;
    private int buildIdX;
    private int buildIdY;
    private String outputImageFormat;
    private int xLocation;
    private int yLocation;
    private String outputImagePath;
    private boolean isBold = false;
    private boolean isItalic = false;
    private float size;
    private String color = "#ffffff";

    public void createImage() throws CreateImageException {
        Font font;
        this.configure();
        this.checkArgumentsNotNull(this.baseImgPath, "baseImgPath");
        this.checkArgumentsNotNull(this.fontName, "fontName");
        this.checkArgumentsNotNull(this.versionLabel, "versionLabel");
        this.checkArgumentsNotNull(this.outputImagePath, "outputImagePath");
        this.checkArgumentsNotNull(this.outputImageFormat, "outputImageFormat");
        try {
            font = this.createCustomFont();
        }
        catch (FontFormatException | IOException e) {
            throw new CreateImageException("Failed to load font.", e);
        }
        BufferedImage loadImg = null;
        try {
            loadImg = this.loadBaseImage();
        }
        catch (IOException e) {
            throw new CreateImageException(e.getMessage(), e);
        }
        BufferedImage img = new BufferedImage(loadImg.getWidth(), loadImg.getHeight(), this.getType());
        this.drawProductVersion(loadImg, img, font);
        try {
            this.writeOutputImage(img);
        }
        catch (IOException e) {
            throw new CreateImageException(e.getMessage(), e);
        }
    }

    private void drawProductVersion(BufferedImage loadImg, BufferedImage img, Font bontitaBrandingFont) {
        Graphics2D graphics = img.createGraphics();
        graphics.drawImage(loadImg, 0, 0, loadImg.getWidth(), loadImg.getHeight(), null);
        graphics.setColor(Color.decode(this.color));
        graphics.setFont(this.configureVersionFontStyle(bontitaBrandingFont));
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawString(this.stripSNAPSHOT(this.getVersionLabel()), this.getxLocation(), this.getyLocation());
        if (this.buildId != null && !this.buildId.isEmpty()) {
            graphics.setFont(this.configureQualifierFontStyle(bontitaBrandingFont));
            graphics.drawString(String.format("Build: %s", this.trimDot(this.buildId)), this.buildIdX, this.buildIdY);
        }
        graphics.dispose();
    }

    String trimDot(String label) {
        return label.lastIndexOf(".") == label.length() - 1 ? label.substring(0, label.length() - 1) : label;
    }

    private int getType() {
        return Objects.equals(this.getOutputImageFormat().toLowerCase(), "bmp") ? 1 : 2;
    }

    protected void writeOutputImage(BufferedImage loadImg) throws IOException {
        if (!ImageIO.write((RenderedImage)loadImg, this.getOutputImageFormat(), new File(this.getOutputImagePath()))) {
            throw new IOException(String.format("Failed to create image %s with %s fromat.", this.getOutputImagePath(), this.getOutputImageFormat()));
        }
    }

    private BufferedImage loadBaseImage() throws IOException {
        File inputFile = this.getBaseImageFile();
        return ImageIO.read(inputFile);
    }

    private void checkArgumentsNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(argName + " must be set.");
        }
    }

    protected void configure() {
        if (this.fontName == null) {
            this.setFontName(DEFAULT_FONT_NAME);
        }
        if (this.size == 0.0f) {
            this.setSize(32.0f);
        }
    }

    private InputStream getDefaultFontInputStream() {
        return SetImageVersion.class.getResourceAsStream("/HelveticaNeueLTStd-Cn.otf");
    }

    private File getBaseImageFile() throws FileNotFoundException {
        File inputFile = new File(this.getBaseImgPath());
        if (!inputFile.exists()) {
            throw new FileNotFoundException(inputFile.getAbsolutePath());
        }
        return inputFile;
    }

    public String getBaseImgPath() {
        return this.baseImgPath;
    }

    public void setBaseImgPath(String baseImgPath) {
        this.baseImgPath = baseImgPath;
    }

    protected Font configureVersionFontStyle(Font bontitaBrandingFont) {
        HashMap<TextAttribute, Number> attributes = new HashMap<TextAttribute, Number>();
        attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
        attributes.put(TextAttribute.BACKGROUND, 3);
        if (this.isItalic) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.isBold) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
        } else {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        }
        return bontitaBrandingFont.deriveFont(0, this.getSize()).deriveFont(attributes);
    }

    protected Font configureQualifierFontStyle(Font bontitaBrandingFont) {
        HashMap<TextAttribute, Number> attributes = new HashMap<TextAttribute, Number>();
        attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
        attributes.put(TextAttribute.BACKGROUND, 3);
        attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
        return bontitaBrandingFont.deriveFont(0, 15.0f).deriveFont(attributes);
    }

    private Font createCustomFont() throws FontFormatException, IOException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font customFont = this.getFont(ge);
        if (customFont == null) {
            try (InputStream fontInputStream = this.getFontResourcePath() != null ? new FileInputStream(new File(this.getFontResourcePath())) : this.getDefaultFontInputStream();){
                customFont = Font.createFont(0, fontInputStream);
                ge.registerFont(customFont);
            }
        }
        return customFont;
    }

    private Font getFont(GraphicsEnvironment ge) {
        for (Font f : ge.getAllFonts()) {
            if (!this.getFontName().equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    String stripSNAPSHOT(String version) {
        if (version != null && version.endsWith("-SNAPSHOT")) {
            version = version.substring(0, version.indexOf("-SNAPSHOT"));
        }
        return version;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getOutputImagePath() {
        return this.outputImagePath;
    }

    public void setOutputImagePath(String outputImagePath) {
        this.outputImagePath = outputImagePath;
    }

    public void setOutputImageFormat(String outputImageFormat) {
        this.outputImageFormat = outputImageFormat;
    }

    public String getOutputImageFormat() {
        return this.outputImageFormat;
    }

    public int getxLocation() {
        return this.xLocation;
    }

    public void setxLocation(int xLocation) {
        this.xLocation = xLocation;
    }

    public int getyLocation() {
        return this.yLocation;
    }

    public void setyLocation(int yLocation) {
        this.yLocation = yLocation;
    }

    public String getFontResourcePath() {
        return this.fontResourcePath;
    }

    public void setFontResourcePath(String fontResourcePath) {
        this.fontResourcePath = fontResourcePath;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }

    public void setBuildIdX(int buildIdX) {
        this.buildIdX = buildIdX;
    }

    public void setBuildIdY(int buildIdY) {
        this.buildIdY = buildIdY;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }
}

