/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.studio.maven.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bonitasoft.studio.maven.plugin.SetImageVersion;
import org.bonitasoft.studio.maven.plugin.exception.CreateImageException;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_RESOURCES, name="create-image", threadSafe=true)
public class SetImageVersionMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String baseImgPath;
    @Parameter(required=true)
    private String outputImagePath;
    @Parameter(required=true)
    private String outputImageFormat;
    @Parameter(required=true)
    private int xLocation;
    @Parameter(required=true)
    private int yLocation;
    @Parameter(required=false)
    private int buildIdX;
    @Parameter(required=false)
    private int buildIdY;
    @Parameter(required=true)
    private String versionLabel;
    @Parameter(required=false)
    private String buildId;
    @Parameter(required=false)
    private String fontName;
    @Parameter(required=false)
    private String fontResourcePath;
    @Parameter(required=false)
    private float fontSize;
    @Parameter(required=false)
    private String color;
    @Parameter(required=false, defaultValue="true")
    private boolean bold;
    @Parameter(required=false, defaultValue="false")
    private boolean italic;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SetImageVersion setImageVersion = this.createSetImageVersion();
        setImageVersion.setBaseImgPath(this.baseImgPath);
        setImageVersion.setOutputImageFormat(this.outputImageFormat);
        setImageVersion.setOutputImagePath(this.outputImagePath);
        setImageVersion.setVersionLabel(this.versionLabel);
        setImageVersion.setBuildId(this.buildId);
        setImageVersion.setBuildIdX(this.buildIdX);
        setImageVersion.setBuildIdY(this.buildIdY);
        setImageVersion.setxLocation(this.xLocation);
        setImageVersion.setyLocation(this.yLocation);
        setImageVersion.setBold(this.bold);
        setImageVersion.setItalic(this.italic);
        if (this.fontName != null) {
            if (this.fontResourcePath == null) {
                throw new MojoFailureException("You must provide a custom font resourcefile when using a custom font name.");
            }
            setImageVersion.setFontName(this.fontName);
            setImageVersion.setFontResourcePath(this.fontResourcePath);
        }
        if (this.fontSize > 0.0f) {
            setImageVersion.setSize(this.fontSize);
        }
        if (this.color != null && !this.color.isEmpty()) {
            if (!this.color.startsWith("#")) {
                this.color = "#" + this.color;
            }
            if (this.color.length() > 7) {
                throw new MojoFailureException("Color parameter has not the expected format eg: 0f125e");
            }
            setImageVersion.setColor(this.color);
        }
        this.getLog().info((CharSequence)("Writing image with version " + this.versionLabel + " to " + this.outputImagePath + "..."));
        try {
            setImageVersion.createImage();
        }
        catch (CreateImageException e) {
            throw new MojoExecutionException("Failed to create target image", (Exception)e);
        }
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    protected SetImageVersion createSetImageVersion() {
        return new SetImageVersion();
    }
}

