/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.nio.file.Paths;
import java.util.Properties;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.DatabaseConfiguration;

class ConfigurationChecker {
    private Properties datasourceProperties;
    private String driverClassName;
    private DatabaseConfiguration dbConfiguration;

    ConfigurationChecker(Properties datasourceProperties) {
        this.datasourceProperties = datasourceProperties;
    }

    void loadProperties() throws PlatformException {
        this.dbConfiguration = new DatabaseConfiguration("", this.datasourceProperties, Paths.get(".", new String[0]));
        this.driverClassName = this.dbConfiguration.getNonXaDriverClassName();
    }

    public void validate() throws PlatformException {
        this.loadProperties();
        this.tryToLoadDriverClass();
    }

    void tryToLoadDriverClass() throws PlatformException {
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new PlatformException("The driver class named '" + this.driverClassName + "' specified in 'internal.properties' configuration file, to connect to your '" + this.dbConfiguration.getDbVendor() + "' database, cannot be found. Either there is an error in the name of the class or the class is not available in the classpath. Make sure the driver class name is correct and that the suitable driver is available in the lib/ folder and then try again.", (Exception)e);
        }
    }
}

