/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.ConfigurationChecker;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.bonitasoft.platform.setup.command.CommandException;
import org.bonitasoft.platform.setup.command.HelpCommand;
import org.bonitasoft.platform.setup.command.InitCommand;
import org.bonitasoft.platform.setup.command.PlatformSetupCommand;
import org.bonitasoft.platform.setup.command.PullCommand;
import org.bonitasoft.platform.setup.command.PushCommand;
import org.bonitasoft.platform.setup.command.configure.ConfigureCommand;
import org.bonitasoft.platform.setup.command.configure.PropertyLoader;
import org.bonitasoft.platform.setup.jndi.MemoryJNDISetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"org.bonitasoft.platform.setup", "org.bonitasoft.platform.configuration", "org.bonitasoft.platform.version"})
public class PlatformSetupApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformSetupApplication.class);
    private HelpCommand helpCommand;
    private List<PlatformSetupCommand> commands;
    private Options options;
    @Autowired
    MemoryJNDISetup memoryJNDISetup;
    @Autowired
    PlatformSetup platformSetup;

    public static void main(String[] args) {
        new PlatformSetupApplication().run(args);
    }

    public static PlatformSetup getPlatformSetup(String[] args) throws PlatformException {
        new ConfigurationChecker(new PropertyLoader().loadProperties()).validate();
        return (PlatformSetup)SpringApplication.run(PlatformSetupApplication.class, (String[])args).getBean(PlatformSetup.class);
    }

    private void run(String[] args) {
        GnuParser parser = new GnuParser();
        this.options = this.createOptions();
        this.commands = this.createCommands();
        this.helpCommand.setCommands(this.commands);
        CommandLine line = this.parseArguments(args, (CommandLineParser)parser);
        this.configureApplication(line);
        this.execute(line);
    }

    private PlatformSetupCommand getCommand(CommandLine line) {
        List argList = line.getArgList();
        if (argList.isEmpty()) {
            return this.helpCommand;
        }
        String commandName = argList.get(0).toString();
        for (PlatformSetupCommand platformSetupCommand : this.commands) {
            if (!commandName.equals(platformSetupCommand.getName())) continue;
            return platformSetupCommand;
        }
        return this.helpCommand;
    }

    private void configureApplication(CommandLine line) {
        Properties systemProperties = line.getOptionProperties("D");
        for (Map.Entry<Object, Object> systemProperty : systemProperties.entrySet()) {
            System.setProperty(systemProperty.getKey().toString(), systemProperty.getValue().toString());
        }
    }

    private void execute(CommandLine line) {
        try {
            this.getCommand(line).execute(this.options, line);
        }
        catch (CommandException e) {
            LOGGER.error(e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ERROR: ", (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
                LOGGER.error("You might get more detailed information about the error by adding '--debug' to the command line, and run again");
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private CommandLine parseArguments(String[] args, CommandLineParser parser) {
        try {
            return parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            System.err.println("ERROR: error while parsing arguments " + exp.getMessage());
            System.exit(1);
            return null;
        }
    }

    private List<PlatformSetupCommand> createCommands() {
        ArrayList<PlatformSetupCommand> commandList = new ArrayList<PlatformSetupCommand>();
        commandList.add(new InitCommand());
        commandList.add(new ConfigureCommand());
        commandList.add(new PullCommand());
        commandList.add(new PushCommand());
        this.helpCommand = new HelpCommand();
        commandList.add(this.helpCommand);
        return commandList;
    }

    private Options createOptions() {
        Options options = new Options();
        Option systemPropertyOption = new Option("D", "specify system property to override configuration from database.properties");
        systemPropertyOption.setArgName("property=value");
        systemPropertyOption.setValueSeparator('=');
        systemPropertyOption.setArgs(2);
        options.addOption(systemPropertyOption);
        options.addOption("f", "force", false, "Force push even if critical folders will be deleted");
        return options;
    }
}

