/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.bonitasoft.platform.exception.PlatformException;

public class PropertyLoader {
    private final List<String> propertyFiles;

    public PropertyLoader(String ... propertyFiles) {
        this.propertyFiles = Arrays.asList(propertyFiles);
    }

    public PropertyLoader() {
        this("/database.properties", "/internal.properties");
    }

    public Properties loadProperties() throws PlatformException {
        Properties properties = new Properties();
        for (String propertyFile : this.propertyFiles) {
            try {
                properties.load(this.getClass().getResourceAsStream(propertyFile));
            }
            catch (IOException e) {
                throw new PlatformException("Error reading configuration file " + propertyFile + ". Please make sure the file is present at the root of the Platform Setup Tool folder, and that is has not been moved of deleted", (Exception)e);
            }
        }
        return properties;
    }
}

