/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.PropertyReader;

public class DatabaseConfiguration {
    public static final String H2_DB_VENDOR = "h2";
    private static final String H2_DATABASE_DIR = "${h2.database.dir}";
    private String dbVendor;
    private String nonXaDriverClassName;
    private String xaDriverClassName;
    private String xaDataSourceFactory;
    private String databaseUser;
    private String databasePassword;
    private String databaseName;
    private String serverName;
    private String serverPort;
    private String url;
    private String testQuery;
    private PropertyReader propertyReader;

    public DatabaseConfiguration(String prefix, Properties properties, Path rootPath) throws PlatformException {
        this.propertyReader = new PropertyReader(properties);
        this.dbVendor = this.getMandatoryProperty(prefix + "db.vendor");
        this.nonXaDriverClassName = this.getMandatoryProperty(this.dbVendor + ".nonXaDriver");
        this.xaDriverClassName = this.getMandatoryProperty(this.dbVendor + ".xaDriver");
        this.xaDataSourceFactory = this.getMandatoryProperty(this.dbVendor + ".xaDSFactory");
        this.databaseName = this.getMandatoryProperty(prefix + "db.database.name");
        this.url = this.getMandatoryProperty(this.dbVendor + "." + prefix + "url");
        if (H2_DB_VENDOR.equals(this.dbVendor)) {
            String h2DatabaseDir = this.getMandatoryProperty("h2.database.dir");
            Path h2DatabasePath = Paths.get(h2DatabaseDir, new String[0]);
            this.url = h2DatabasePath.isAbsolute() || h2DatabaseDir.startsWith("${") ? this.url.replace(H2_DATABASE_DIR, h2DatabasePath.normalize().toString()) : this.url.replace(H2_DATABASE_DIR, rootPath.resolve("setup").resolve(h2DatabaseDir).toAbsolutePath().normalize().toString());
            this.url = this.url.replace("\\", "/");
        } else {
            this.serverName = this.getMandatoryProperty(prefix + "db.server.name");
            this.url = this.url.replace("${" + prefix + "db.server.name}", this.serverName);
            this.serverPort = this.getMandatoryProperty(prefix + "db.server.port");
            this.url = this.url.replace("${" + prefix + "db.server.port}", this.serverPort);
        }
        this.url = this.url.replace("${" + prefix + "db.database.name}", this.databaseName);
        this.databaseUser = this.getMandatoryProperty(prefix + "db.user");
        this.databasePassword = this.getMandatoryProperty(prefix + "db.password");
        this.testQuery = this.getMandatoryProperty(this.dbVendor + "." + prefix + "testQuery");
    }

    public String getDbVendor() {
        return this.dbVendor;
    }

    public String getNonXaDriverClassName() {
        return this.nonXaDriverClassName;
    }

    String getXaDriverClassName() {
        return this.xaDriverClassName;
    }

    public String getXaDataSourceFactory() {
        return this.xaDataSourceFactory;
    }

    String getDatabaseUser() {
        return this.databaseUser;
    }

    String getDatabasePassword() {
        return this.databasePassword;
    }

    String getDatabaseName() {
        return this.databaseName;
    }

    String getServerName() {
        return this.serverName != null ? this.serverName : "";
    }

    String getServerPort() {
        return this.serverPort != null ? this.serverPort : "";
    }

    String getUrl() {
        return this.url;
    }

    String getTestQuery() {
        return this.testQuery;
    }

    private String getMandatoryProperty(String s) throws PlatformException {
        return this.propertyReader.getPropertyAndFailIfNull(s);
    }
}

