/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.util.Properties;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.BundleConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleConfigurator.class);
    private final Properties properties;

    public PropertyReader(Properties properties) {
        this.properties = properties;
    }

    public String getPropertyAndFailIfNull(String propertyName) throws PlatformException {
        String sysPropValue = System.getProperty(propertyName);
        if (sysPropValue != null) {
            LOGGER.info("System property '{}' set to '{}', overriding value from file database.properties.", (Object)propertyName, (Object)sysPropValue);
            return sysPropValue.trim();
        }
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new PlatformException("Mandatory property '" + propertyName + "' is missing. Ensure you did not remove lines from file 'database.properties' (neither from file 'internal.properties') and that the line is NOT commented out with a '#' character at start of line.");
        }
        return property.trim();
    }
}

