/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.BundleConfigurator;
import org.bonitasoft.platform.setup.command.configure.DatabaseConfiguration;

class TomcatBundleConfigurator
extends BundleConfigurator {
    private static final String TOMCAT_BACKUP_FOLDER = "tomcat-backups";

    TomcatBundleConfigurator(Path rootPath) throws PlatformException {
        super(rootPath);
    }

    @Override
    protected String getBundleName() {
        return "Tomcat";
    }

    @Override
    public void configureApplicationServer() throws PlatformException {
        this.loadProperties();
        String dbVendor = this.standardConfiguration.getDbVendor();
        String bdmDbVendor = this.bdmConfiguration.getDbVendor();
        Path setEnvUnixFile = this.getPathUnderAppServer("bin/setenv.sh", true);
        Path setEnvWindowsFile = this.getPathUnderAppServer("bin/setenv.bat", true);
        Path bonitaXmlFile = this.getPathUnderAppServer("conf/Catalina/localhost/bonita.xml", false);
        File bonitaDbDriverFile = this.getDriverFile(dbVendor);
        File bdmDriverFile = this.getDriverFile(bdmDbVendor);
        try {
            this.createBackupFolderIfNecessary("setup/tomcat-backups");
            String newContent = this.readContentFromFile(this.getTemplateFolderPath("setenv.bat"));
            newContent = this.updateSetEnvFile(newContent, dbVendor, "sysprop.bonita.db.vendor");
            newContent = this.updateSetEnvFile(newContent, bdmDbVendor, "sysprop.bonita.bdm.db.vendor");
            this.backupAndReplaceContentIfNecessary(setEnvWindowsFile, newContent, "Setting Bonita internal database vendor to '" + dbVendor + "' and Business Data database vendor to '" + bdmDbVendor + "' in 'setenv.bat' file");
            newContent = this.readContentFromFile(this.getTemplateFolderPath("setenv.sh"));
            newContent = this.updateSetEnvFile(newContent, dbVendor, "sysprop.bonita.db.vendor");
            newContent = this.updateSetEnvFile(newContent, bdmDbVendor, "sysprop.bonita.bdm.db.vendor");
            this.backupAndReplaceContentIfNecessary(setEnvUnixFile, newContent, "Setting Bonita internal database vendor to '" + dbVendor + "' and Business Data database vendor to '" + bdmDbVendor + "' in 'setenv.sh' file");
            newContent = this.readContentFromFile(this.getTemplateFolderPath("bonita.xml"));
            newContent = this.updateBonitaXmlFile(newContent, this.standardConfiguration, "ds1");
            newContent = this.updateBonitaXmlFile(newContent, this.bdmConfiguration, "ds2");
            this.backupAndReplaceContentIfNecessary(bonitaXmlFile, newContent, "Configuring file 'conf/Catalina/localhost/bonita.xml' with your DB values for Bonita internal database on '" + dbVendor + "' and for Business Data database on '" + bdmDbVendor + "'");
            Path srcDriverFile = bonitaDbDriverFile.toPath();
            Path targetBonitaDbDriverFile = this.getPathUnderAppServer("lib/bonita", true).resolve(srcDriverFile.getFileName());
            this.copyDatabaseDriversIfNecessary(srcDriverFile, targetBonitaDbDriverFile, dbVendor);
            Path srcBdmDriverFile = bdmDriverFile.toPath();
            Path targetBdmDriverFile = this.getPathUnderAppServer("lib/bonita", true).resolve(srcBdmDriverFile.getFileName());
            this.copyDatabaseDriversIfNecessary(srcBdmDriverFile, targetBdmDriverFile, bdmDbVendor);
            this.removeH2DriverIfNecessary(targetBonitaDbDriverFile.getParent(), dbVendor, bdmDbVendor);
            LOGGER.info("Tomcat auto-configuration complete.");
        }
        catch (PlatformException e) {
            this.restorePreviousConfiguration(setEnvUnixFile, setEnvWindowsFile, bonitaXmlFile);
            throw e;
        }
    }

    private String updateBonitaXmlFile(String content, DatabaseConfiguration configuration, String datasourceAlias) {
        HashMap<String, String> replacements = new HashMap<String, String>(5);
        replacements.put("@@" + datasourceAlias + ".database_connection_user@@", Matcher.quoteReplacement(configuration.getDatabaseUser()));
        replacements.put("@@" + datasourceAlias + ".database_connection_password@@", Matcher.quoteReplacement(configuration.getDatabasePassword()));
        replacements.put("@@" + datasourceAlias + ".driver_class_name@@", configuration.getNonXaDriverClassName());
        replacements.put("@@" + datasourceAlias + ".xa.driver_class_name@@", configuration.getXaDriverClassName());
        replacements.put("@@" + datasourceAlias + ".xa_datasource_factory@@", configuration.getXaDataSourceFactory());
        replacements.put("@@" + datasourceAlias + ".database_connection_url@@", TomcatBundleConfigurator.getDatabaseConnectionUrlForXmlFile(configuration));
        replacements.put("@@" + datasourceAlias + "_database_server_name@@", configuration.getServerName());
        replacements.put("@@" + datasourceAlias + "_database_port_number@@", configuration.getServerPort());
        replacements.put("@@" + datasourceAlias + "_database_database_name@@", Matcher.quoteReplacement(configuration.getDatabaseName()));
        replacements.put("@@" + datasourceAlias + ".database_test_query@@", configuration.getTestQuery());
        return TomcatBundleConfigurator.replaceValues(content, replacements);
    }

    private String updateSetEnvFile(String setEnvFileContent, String dbVendor, String systemPropertyName) {
        Map<CallSite, CallSite> replacementMap = Collections.singletonMap("-D" + systemPropertyName + "=.*\"", "-D" + systemPropertyName + "=" + dbVendor + "\"");
        return TomcatBundleConfigurator.replaceValues(setEnvFileContent, replacementMap);
    }

    void restorePreviousConfiguration(Path setEnvUnixFile, Path setEnvWindowsFile, Path bonitaXmlFile) throws PlatformException {
        LOGGER.warn("Problem encountered, restoring previous configuration");
        this.restoreOriginalFile(bonitaXmlFile);
        this.restoreOriginalFile(setEnvUnixFile);
        this.restoreOriginalFile(setEnvWindowsFile);
    }
}

