/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.io.IOException;
import java.util.Properties;
import org.bonitasoft.platform.exception.PlatformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationChecker.class);
    private String dbVendor;
    private String driverClassName;

    private void loadProperties() throws PlatformException {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("/database.properties"));
        }
        catch (IOException e) {
            throw new PlatformException("Error reading configuration file database.properties. Please make sure the file is present at the root of the Platform Setup Tool folder, and that is has not been moved of deleted", e);
        }
        this.dbVendor = properties.getProperty("db.vendor");
        String sysPropDbVendor = System.getProperty("sysprop.bonita.db.vendor");
        if (sysPropDbVendor != null) {
            LOGGER.debug("'sysprop.bonita.db.vendor' set to '" + sysPropDbVendor + "', overriding value from file database.properties.");
            this.dbVendor = sysPropDbVendor;
        }
        this.driverClassName = properties.getProperty(this.dbVendor + ".driverClassName");
        if (this.driverClassName == null) {
            throw new PlatformException("Driver class name not set for database " + this.dbVendor + " in file database.properties. In most cases, you should not edit the default driver class name value." + " Please ensure ");
        }
    }

    public void validate() throws PlatformException {
        this.loadProperties();
        this.validateDriverClass();
    }

    void validateDriverClass() throws PlatformException {
        this.tryToLoadDriverClass(this.driverClassName);
    }

    void tryToLoadDriverClass(String driverClass) throws PlatformException {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new PlatformException("The driver class named '" + driverClass + "' specified in 'database.properties' configuration file, to connect to your '" + this.dbVendor + "' database, cannot be found." + " Either there is an error in the name of the class or the class is not available in the classpath." + " Make sure the driver class name is correct and that the suitable driver is available in the lib/ folder and then try again.", e);
        }
    }
}

