/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.DataSourceLookup;
import org.bonitasoft.platform.setup.ScriptExecutor;
import org.bonitasoft.platform.version.VersionService;
import org.bonitasoft.platform.version.impl.VersionServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PlatformSetup {
    public static final String BONITA_SETUP_FOLDER = "org.bonitasoft.platform.setup.folder";
    static final String BONITA_SETUP_ACTION = "org.bonitasoft.platform.setup.action";
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformSetup.class);
    public static final String PLATFORM_CONF_FOLDER_NAME = "platform_conf";
    public static final String BONITA_CLIENT_HOME_FOLDER = "bonita.client.home";
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private VersionService versionService;
    @Value(value="${db.vendor}")
    private String dbVendor;
    @Autowired
    private DataSource dataSource;
    private Path initialConfigurationFolder;
    private Path currentConfigurationFolder;
    private Path licensesFolder;

    public PlatformSetup(String dbVendor) {
        this.dbVendor = dbVendor;
    }

    public PlatformSetup() {
    }

    public void setDataSource(String driverClassName, String username, String password, String url) {
        this.dataSource = new DataSourceBuilder(PlatformSetup.class.getClassLoader()).driverClassName(driverClassName).username(username).password(password).url(url).build();
    }

    public void init() throws PlatformException {
        this.initPlatformSetup();
        this.preventFromPushingZeroLicense();
        if (this.isPlatformAlreadyCreated()) {
            LOGGER.info("Platform is already created. Nothing to do.");
            return;
        }
        this.initializePlatform();
        LOGGER.info("Platform created.");
        if (Files.isDirectory(this.initialConfigurationFolder, new LinkOption[0])) {
            LOGGER.info("Database will be initialized with configuration files from folder: " + this.currentConfigurationFolder.toString());
            this.pushFromFolder(this.initialConfigurationFolder);
        } else {
            LOGGER.warn("Database will be initialized with configuration files from classpath");
            this.initConfigurationWithClasspath();
        }
        this.pushLicenses();
        LOGGER.info("Initial configuration files successfully pushed to database");
    }

    boolean isPlatformAlreadyCreated() {
        return this.scriptExecutor.isPlatformAlreadyCreated();
    }

    private void pushFromFolder(Path folderToPush) throws PlatformException {
        this.configurationService.storeAllConfiguration(folderToPush.toFile());
    }

    private void checkPushFolderExists(Path folderToPush) throws PlatformException {
        if (!Files.isDirectory(folderToPush, new LinkOption[0])) {
            throw new PlatformException("Unable to push configuration from " + folderToPush + ", as directory does not exists. To modify your configuration, run 'setup pull', update your configuration files from " + this.currentConfigurationFolder + " folder, and then push your new configuration.");
        }
    }

    void clean() {
        this.configurationService.deleteAllConfiguration();
    }

    public void push() throws PlatformException {
        this.initPlatformSetup();
        if (!this.isPlatformAlreadyCreated()) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.");
        }
        this.preventFromPushingZeroLicense();
        this.checkPlatformVersion();
        this.checkPushFolderExists(this.currentConfigurationFolder);
        LOGGER.info("Configuration currently in database will be replace by configuration from folder: " + this.currentConfigurationFolder.toString());
        this.clean();
        this.pushFromFolder(this.currentConfigurationFolder);
        this.pushLicenses();
        LOGGER.info("Configuration files successfully pushed to database. You can now restart Bonita BPM to reflect your changes.");
    }

    void pull() throws PlatformException {
        this.initPlatformSetup();
        this.checkPlatformVersion();
        LOGGER.info("Pulling configuration into folder: " + this.currentConfigurationFolder);
        if (Files.isDirectory(this.licensesFolder, new LinkOption[0])) {
            LOGGER.info("Pulling licenses into folder: " + this.licensesFolder);
        }
        this.pull(this.currentConfigurationFolder, this.licensesFolder);
        LOGGER.info("Configuration (and license) files successfully pulled. You can now edit them. Use \"setup push\" when done.");
    }

    public void pull(Path configurationFolder, Path licensesFolder) throws PlatformException {
        try {
            this.recreateDirectory(configurationFolder);
            if (Files.isDirectory(licensesFolder, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)licensesFolder.toFile());
            }
            this.configurationService.writeAllConfigurationToFolder(configurationFolder.toFile(), licensesFolder.toFile());
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    private void recreateDirectory(Path ... folders) throws IOException {
        for (Path folder : folders) {
            if (Files.exists(folder, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)folder.toFile());
            }
            Files.createDirectories(folder, new FileAttribute[0]);
        }
    }

    private void checkPlatformVersion() throws PlatformException {
        if (!this.versionService.isValidPlatformVersion()) {
            throw new PlatformException("Platform version [" + this.versionService.getPlatformVersion() + "] is not supported by current platform setup version [" + this.versionService.getPlatformSetupVersion() + "]");
        }
    }

    private void pushLicenses() throws PlatformException {
        if (!Files.isDirectory(this.licensesFolder, new LinkOption[0])) {
            return;
        }
        LOGGER.info("Pushing license files from folder:" + this.licensesFolder.toString());
        this.configurationService.storeLicenses(this.licensesFolder.toFile());
    }

    private void initializePlatform() throws PlatformException {
        this.scriptExecutor.createAndInitializePlatformIfNecessary();
    }

    void initProperties() {
        Path platformConfFolder;
        String setupFolderPath;
        if (this.dbVendor == null) {
            this.dbVendor = System.getProperty("sysprop.bonita.db.vendor");
        }
        if ((setupFolderPath = System.getProperty(BONITA_SETUP_FOLDER)) != null) {
            LOGGER.info("System property org.bonitasoft.platform.setup.folder is set to " + setupFolderPath);
            platformConfFolder = Paths.get(setupFolderPath, new String[0]).resolve(PLATFORM_CONF_FOLDER_NAME);
        } else {
            platformConfFolder = Paths.get(PLATFORM_CONF_FOLDER_NAME, new String[0]);
        }
        this.initializeFoldersPaths(platformConfFolder);
    }

    private void initializeFoldersPaths(Path platformConfFolder) {
        this.initialConfigurationFolder = platformConfFolder.resolve("initial");
        this.currentConfigurationFolder = platformConfFolder.resolve("current");
        this.licensesFolder = this.getLicenseInitialFolder(platformConfFolder);
    }

    private Path getLicenseInitialFolder(Path platformConfFolder) {
        String bonita_client_home = System.getProperty(BONITA_CLIENT_HOME_FOLDER);
        if (bonita_client_home != null) {
            return Paths.get(bonita_client_home, new String[0]);
        }
        return platformConfFolder.resolve("licenses");
    }

    private void initConfigurationWithClasspath() throws PlatformException {
        try {
            ArrayList<BonitaConfiguration> platformInitConfigurations = new ArrayList<BonitaConfiguration>();
            this.addIfExists(platformInitConfigurations, ConfigurationType.PLATFORM_INIT_ENGINE, "bonita-platform-init-community-custom.properties");
            this.addIfExists(platformInitConfigurations, ConfigurationType.PLATFORM_INIT_ENGINE, "bonita-platform-init-custom.xml");
            this.configurationService.storePlatformInitEngineConf(platformInitConfigurations);
            ArrayList<BonitaConfiguration> platformConfigurations = new ArrayList<BonitaConfiguration>();
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-community-custom.properties");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-custom.xml");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-private-community.properties");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-sp-custom.properties");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-sp-cluster-custom.properties");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-sp-custom.xml");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-platform-hibernate-cache.xml");
            this.addIfExists(platformConfigurations, ConfigurationType.PLATFORM_ENGINE, "bonita-tenant-hibernate-cache.xml");
            this.configurationService.storePlatformEngineConf(platformConfigurations);
            ArrayList<BonitaConfiguration> tenantTemplateConfigurations = new ArrayList<BonitaConfiguration>();
            this.addIfExists(tenantTemplateConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, "bonita-tenant-community-custom.properties");
            this.addIfExists(tenantTemplateConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, "bonita-tenants-custom.xml");
            this.addIfExists(tenantTemplateConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, "bonita-tenant-sp-custom.properties");
            this.addIfExists(tenantTemplateConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, "bonita-tenant-sp-cluster-custom.properties");
            this.addIfExists(tenantTemplateConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, "bonita-tenant-sp-custom.xml");
            this.configurationService.storeTenantTemplateEngineConf(tenantTemplateConfigurations);
            ArrayList<BonitaConfiguration> securityScripts = new ArrayList<BonitaConfiguration>();
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ActorMemberPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ActorPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "CaseContextPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "CasePermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "CaseVariablePermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "CommentPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ConnectorInstancePermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "DocumentPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessConfigurationPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessConnectorDependencyPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessInstantiationPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessResolutionProblemPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProcessSupervisorPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProfileEntryPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "ProfilePermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "TaskExecutionPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "TaskPermissionRule.groovy");
            this.addIfExists(securityScripts, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, "UserPermissionRule.groovy");
            this.configurationService.storeTenantTemplateSecurityScripts(securityScripts);
            ArrayList<BonitaConfiguration> portalTenantTemplate = new ArrayList<BonitaConfiguration>();
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "authenticationManager-config.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "compound-permissions-mapping.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "console-config.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "custom-permissions-mapping.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "dynamic-permissions-checks.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "forms-config.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "resources-permissions-mapping.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "security-config.properties");
            this.addIfExists(portalTenantTemplate, ConfigurationType.TENANT_TEMPLATE_PORTAL, "autologin-v6.json");
            this.configurationService.storeTenantTemplatePortalConf(portalTenantTemplate);
            ArrayList<BonitaConfiguration> portalPlatform = new ArrayList<BonitaConfiguration>();
            this.addIfExists(portalPlatform, ConfigurationType.PLATFORM_PORTAL, "cache-config.xml");
            this.addIfExists(portalPlatform, ConfigurationType.PLATFORM_PORTAL, "jaas-standard.cfg");
            this.addIfExists(portalPlatform, ConfigurationType.PLATFORM_PORTAL, "platform-tenant-config.properties");
            this.addIfExists(portalPlatform, ConfigurationType.PLATFORM_PORTAL, "security-config.properties");
            this.configurationService.storePlatformPortalConf(portalPlatform);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    private void addIfExists(List<BonitaConfiguration> tenantTemplateConfigurations, ConfigurationType configurationType, String resourceName) throws IOException {
        BonitaConfiguration bonitaConfiguration = this.getBonitaConfigurationFromClassPath(configurationType.name().toLowerCase(), resourceName);
        if (bonitaConfiguration != null) {
            tenantTemplateConfigurations.add(bonitaConfiguration);
        }
    }

    private void initServices() throws PlatformException {
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new ScriptExecutor(this.dbVendor, this.dataSource);
        }
        if (this.configurationService == null) {
            DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(this.dataSource);
            this.configurationService = new ConfigurationServiceImpl(new JdbcTemplate(this.dataSource), new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager), this.dbVendor);
        }
        if (this.versionService == null) {
            this.versionService = new VersionServiceImpl(new JdbcTemplate(this.dataSource), this.dbVendor);
        }
    }

    private void initDataSource() throws PlatformException {
        try {
            if (this.dataSource == null) {
                this.dataSource = new DataSourceLookup().lookup();
            }
            try (Connection connection = this.dataSource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                LOGGER.info("Connected to '" + this.dbVendor + "' database with url: '" + metaData.getURL() + "' with user: '" + metaData.getUserName() + "'");
            }
        }
        catch (SQLException | NamingException e) {
            throw new PlatformException(e);
        }
    }

    private BonitaConfiguration getBonitaConfigurationFromClassPath(String folder, String resourceName) throws IOException {
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + folder + "/" + resourceName);){
            if (resourceAsStream == null) {
                BonitaConfiguration bonitaConfiguration = null;
                return bonitaConfiguration;
            }
            LOGGER.debug("Using configuration from classpath " + resourceName);
            BonitaConfiguration bonitaConfiguration = new BonitaConfiguration(resourceName, IOUtils.toByteArray((InputStream)resourceAsStream));
            return bonitaConfiguration;
        }
    }

    public void destroy() throws PlatformException {
        this.initPlatformSetup();
        if (this.isPlatformAlreadyCreated()) {
            this.scriptExecutor.deleteTables();
        }
    }

    public void initPlatformSetup() throws PlatformException {
        this.initProperties();
        this.initDataSource();
        this.initServices();
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    void preventFromPushingZeroLicense() throws PlatformException {
        String[] licenseFiles;
        if (Files.isDirectory(this.licensesFolder, new LinkOption[0]) && (licenseFiles = this.licensesFolder.toFile().list((FilenameFilter)new RegexFileFilter(".*\\.lic"))).length == 0) {
            throw new PlatformException("No license (.lic file) found.\nThis would prevent Bonita BPM Platform subscription edition to start normally.\nPlace your license file in " + this.licensesFolder.toString() + " and then try again.");
        }
    }
}

