/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.model;

import java.util.Arrays;
import java.util.Objects;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;

public class FullBonitaConfiguration
extends BonitaConfiguration {
    private final String configurationType;
    private final Long tenantId;

    public FullBonitaConfiguration(String resourceName, byte[] resourceContent, String configurationType, Long tenantId) {
        super(resourceName, resourceContent);
        this.configurationType = configurationType;
        this.tenantId = tenantId;
    }

    public String getConfigurationType() {
        return this.configurationType;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullBonitaConfiguration that = (FullBonitaConfiguration)o;
        return Objects.equals(this.getResourceName(), that.getResourceName()) && Arrays.equals(this.getResourceContent(), that.getResourceContent()) && Objects.equals(this.getResourceName(), that.getResourceName()) && Objects.equals(this.getTenantId(), that.getTenantId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getResourceName(), this.getResourceContent(), this.configurationType);
    }

    @Override
    public String toString() {
        return String.format("FullBonitaConfiguration{ resourceName='%s' , configurationType='%s' , tenantId=%d }", this.getResourceName(), this.getConfigurationType(), this.getTenantId());
    }

    public boolean isLicenseFile() {
        return this.getConfigurationType().equals(ConfigurationType.LICENSES.name());
    }

    public boolean isTenantFile() {
        return this.getTenantId() > 0L;
    }
}

