/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllConfigurationResourceVisitor
extends SimpleFileVisitor<Path> {
    private final List<FullBonitaConfiguration> fullBonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(AllConfigurationResourceVisitor.class);
    private static final List<String> PLATFORM_FOLDERS = Arrays.asList(ConfigurationType.PLATFORM_PORTAL.name().toLowerCase(), ConfigurationType.PLATFORM_INIT_ENGINE.name().toLowerCase(), ConfigurationType.PLATFORM_ENGINE.name().toLowerCase(), ConfigurationType.TENANT_TEMPLATE_ENGINE.name().toLowerCase(), ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS.name().toLowerCase(), ConfigurationType.TENANT_TEMPLATE_PORTAL.name().toLowerCase());
    private static final List<String> TENANT_FOLDERS = Arrays.asList(ConfigurationType.TENANT_PORTAL.name().toLowerCase(), ConfigurationType.TENANT_ENGINE.name().toLowerCase(), ConfigurationType.TENANT_SECURITY_SCRIPTS.name().toLowerCase());

    public AllConfigurationResourceVisitor(List<FullBonitaConfiguration> fullBonitaConfigurations) {
        this.fullBonitaConfigurations = fullBonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    private String getFolderName(Path dir) {
        return dir.getFileName().toString().toUpperCase();
    }

    private boolean isTenantFolder(Path dir) {
        return TENANT_FOLDERS.contains(dir.getFileName().toString());
    }

    private Long getTenantId(Path dir) {
        try {
            return Long.parseLong(dir.getParent().getFileName().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private boolean isPlatformFolder(Path dir) {
        return PLATFORM_FOLDERS.contains(dir.getFileName().toString());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(basicFileAttributes);
        File file = path.toFile();
        if (this.isConfigurationFile(path)) {
            Long tenantId = this.getTenantId(path.getParent());
            String configurationType = this.getFolderName(path.getParent());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                LOGGER.debug(this.buildMessage(file, tenantId, configurationType));
                this.fullBonitaConfigurations.add(new FullBonitaConfiguration(file.getName(), IOUtils.toByteArray((InputStream)fileInputStream), configurationType, tenantId));
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private String buildMessage(File file, Long tenantId, String configurationType) {
        StringBuilder message = new StringBuilder("found file: ");
        if (tenantId > 0L) {
            message.append("tenants/").append(tenantId).append("/").append(configurationType.toLowerCase());
        } else {
            message.append(configurationType.toLowerCase());
        }
        message.append("/").append(file.getName());
        return message.toString();
    }

    private boolean isConfigurationFile(Path path) {
        Path parentFolder = path.getParent();
        return path.toFile().isFile() && (this.isTenantFolder(parentFolder) || this.isPlatformFolder(parentFolder));
    }
}

