/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationRowMapper;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class GetConfigurationsInTransaction
implements TransactionCallback<List<BonitaConfiguration>> {
    private final JdbcTemplate jdbcTemplate;
    private final long tenantId;
    private final ConfigurationType type;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    public GetConfigurationsInTransaction(JdbcTemplate jdbcTemplate, long tenantId, ConfigurationType type) {
        this.jdbcTemplate = jdbcTemplate;
        this.tenantId = tenantId;
        this.type = type;
    }

    public List<BonitaConfiguration> doInTransaction(TransactionStatus status) {
        LOGGER.debug("get configurations for type:" + this.type.name() + " and tenant id:" + this.tenantId);
        List bonitaConfigurations = this.jdbcTemplate.query("SELECT tenant_id, content_type, resource_name, resource_content FROM configuration WHERE tenant_id = ? AND content_type = ? ORDER BY resource_name", new Object[]{this.tenantId, this.type.name()}, (RowMapper)new BonitaConfigurationRowMapper());
        LOGGER.debug("configurations found:" + bonitaConfigurations.toString());
        return bonitaConfigurations;
    }
}

