/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.ConfigurationChecker;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.bonitasoft.platform.setup.jndi.MemoryJNDISetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"org.bonitasoft.platform.setup", "org.bonitasoft.platform.configuration", "org.bonitasoft.platform.version"})
public class PlatformSetupApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformSetupApplication.class);
    private static final String ACTION_INIT = "init";
    private static final String ACTION_PUSH = "push";
    private static final String ACTION_PULL = "pull";
    @Autowired
    MemoryJNDISetup memoryJNDISetup;
    @Autowired
    PlatformSetup platformSetup;

    public static void main(String[] args) throws Exception {
        try {
            String action = System.getProperty("org.bonitasoft.platform.setup.action");
            if (action != null) {
                switch (action) {
                    case "init": {
                        PlatformSetupApplication.init(PlatformSetupApplication.getConfigurableApplicationContext(args));
                        break;
                    }
                    case "push": {
                        PlatformSetupApplication.push(PlatformSetupApplication.getConfigurableApplicationContext(args));
                        break;
                    }
                    case "pull": {
                        PlatformSetupApplication.pull(PlatformSetupApplication.getConfigurableApplicationContext(args));
                        break;
                    }
                    default: {
                        PlatformSetupApplication.displayMessageAndExit(action);
                        break;
                    }
                }
            } else {
                PlatformSetupApplication.displayMessageAndExit("null");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            System.exit(1);
        }
    }

    private static ConfigurableApplicationContext getConfigurableApplicationContext(String[] args) throws PlatformException {
        new ConfigurationChecker().validate();
        return SpringApplication.run(PlatformSetupApplication.class, (String[])args);
    }

    private static void displayMessageAndExit(String action) {
        System.err.println("ERROR: unknown argument value for 'action': " + action);
        System.exit(1);
    }

    private static void pull(ConfigurableApplicationContext run) throws PlatformException {
        ((PlatformSetup)run.getBean(PlatformSetup.class)).pull();
    }

    private static void push(ConfigurableApplicationContext run) throws PlatformException {
        ((PlatformSetup)run.getBean(PlatformSetup.class)).push();
    }

    private static void init(ConfigurableApplicationContext run) throws PlatformException {
        ((PlatformSetup)run.getBean(PlatformSetup.class)).init();
    }
}

