/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.impl.FolderResolver;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.bonitasoft.platform.configuration.util.AllConfigurationResourceVisitor;
import org.bonitasoft.platform.configuration.util.CleanAndStoreAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.CleanAndStoreConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.ConfigurationResourceVisitor;
import org.bonitasoft.platform.configuration.util.DeleteAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.DeleteTenantConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetConfigurationsInTransaction;
import org.bonitasoft.platform.configuration.util.LicensesResourceVisitor;
import org.bonitasoft.platform.configuration.util.StoreConfigurationInTransaction;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.DataSourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final int NON_TENANT_RESOURCE = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    @Value(value="${db.vendor}")
    private String dbVendor;

    @Autowired
    public ConfigurationServiceImpl(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public ConfigurationServiceImpl(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, String dbVendor) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.dbVendor = dbVendor;
    }

    public ConfigurationServiceImpl() throws NamingException {
        DataSource dataSource = new DataSourceLookup().lookup();
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager);
    }

    @Override
    public List<BonitaConfiguration> getPlatformPortalConf() {
        return this.getNonTenantResource(ConfigurationType.PLATFORM_PORTAL);
    }

    @Override
    public List<BonitaConfiguration> getPlatformInitEngineConf() {
        return this.getNonTenantResource(ConfigurationType.PLATFORM_INIT_ENGINE);
    }

    @Override
    public List<BonitaConfiguration> getPlatformEngineConf() {
        return this.getNonTenantResource(ConfigurationType.PLATFORM_ENGINE);
    }

    @Override
    public List<BonitaConfiguration> getTenantTemplateEngineConf() {
        return this.getNonTenantResource(ConfigurationType.TENANT_TEMPLATE_ENGINE);
    }

    @Override
    public List<BonitaConfiguration> getTenantTemplateSecurityScripts() {
        return this.getNonTenantResource(ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS);
    }

    @Override
    public void storePlatformInitEngineConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.PLATFORM_INIT_ENGINE, 0L);
    }

    @Override
    public void storePlatformEngineConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.PLATFORM_ENGINE, 0L);
    }

    @Override
    public void storeTenantTemplateEngineConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_TEMPLATE_ENGINE, 0L);
    }

    @Override
    public void storeTenantTemplateSecurityScripts(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_TEMPLATE_SECURITY_SCRIPTS, 0L);
    }

    @Override
    public void storeTenantEngineConf(List<BonitaConfiguration> bonitaConfigurations, long tenantId) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_ENGINE, tenantId);
    }

    @Override
    public void storeTenantSecurityScripts(List<BonitaConfiguration> bonitaConfigurations, long tenantId) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_SECURITY_SCRIPTS, tenantId);
    }

    public List<BonitaConfiguration> getAllTenantsPortalConf() {
        return this.getNonTenantResource(ConfigurationType.TENANT_PORTAL);
    }

    public List<BonitaConfiguration> getAllTenantsEngineConf() {
        return this.getNonTenantResource(ConfigurationType.TENANT_ENGINE);
    }

    @Override
    public void storeTenantConfiguration(File configurationRootFolder, long tenantId) throws PlatformException {
        this.storeConfiguration(configurationRootFolder, ConfigurationType.TENANT_PORTAL, tenantId);
    }

    @Override
    public void storePlatformConfiguration(File configurationRootFolder) throws PlatformException {
        this.storeConfiguration(configurationRootFolder, ConfigurationType.PLATFORM_ENGINE, 0L);
    }

    @Override
    public void storeAllConfiguration(File configurationRootFolder) throws PlatformException {
        Path path = configurationRootFolder.toPath();
        ArrayList<FullBonitaConfiguration> fullBonitaConfigurations = new ArrayList<FullBonitaConfiguration>();
        AllConfigurationResourceVisitor allConfigurationResourceVisitor = new AllConfigurationResourceVisitor(fullBonitaConfigurations);
        try {
            Files.walkFileTree(path, allConfigurationResourceVisitor);
            this.transactionTemplate.execute((TransactionCallback)new CleanAndStoreAllConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, fullBonitaConfigurations));
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    @Override
    public void storeTenantTemplatePortalConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_TEMPLATE_PORTAL, 0L);
    }

    @Override
    public void storeTenantPortalConf(List<BonitaConfiguration> bonitaConfigurations, long tenantId) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_PORTAL, tenantId);
    }

    @Override
    public void storePlatformPortalConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.PLATFORM_PORTAL, 0L);
    }

    @Override
    public List<BonitaConfiguration> getTenantTemplatePortalConf() {
        return this.getNonTenantResource(ConfigurationType.TENANT_TEMPLATE_PORTAL);
    }

    @Override
    public List<BonitaConfiguration> getTenantPortalConf(long tenantId) {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_PORTAL, tenantId);
    }

    @Override
    public BonitaConfiguration getTenantPortalConfiguration(long tenantId, String file) {
        return this.getBonitaConfiguration(ConfigurationType.TENANT_PORTAL, tenantId, file);
    }

    @Override
    public List<File> writeAllConfigurationToFolder(File configurationFolder, File licenseFolder) throws PlatformException {
        FolderResolver folderResolver = new FolderResolver(configurationFolder.toPath(), licenseFolder.toPath());
        ArrayList<File> writtenFiles = new ArrayList<File>();
        for (FullBonitaConfiguration fullBonitaConfiguration : this.getAllConfiguration()) {
            File confFile = new File(folderResolver.getFolder(fullBonitaConfiguration), fullBonitaConfiguration.getResourceName());
            writtenFiles.add(confFile);
            LOGGER.debug(String.format("writing file %s to folder %s", confFile.getName(), confFile.getParentFile().getAbsolutePath()));
            try {
                IOUtils.write((byte[])fullBonitaConfiguration.getResourceContent(), (OutputStream)new FileOutputStream(confFile));
            }
            catch (IOException e) {
                throw new PlatformException(e);
            }
        }
        return writtenFiles;
    }

    protected List<FullBonitaConfiguration> getAllConfiguration() {
        return (List)this.transactionTemplate.execute((TransactionCallback)new GetAllConfigurationInTransaction(this.jdbcTemplate));
    }

    private void storeConfiguration(File configurationRootFolder, ConfigurationType type, long tenantId) throws PlatformException {
        Path path = configurationRootFolder.toPath();
        ArrayList<BonitaConfiguration> bonitaConfigurations = new ArrayList<BonitaConfiguration>();
        ConfigurationResourceVisitor configurationResourceVisitor = new ConfigurationResourceVisitor(bonitaConfigurations);
        try {
            Files.walkFileTree(path, configurationResourceVisitor);
            this.storeConfiguration(bonitaConfigurations, type, tenantId);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    private void storeConfiguration(List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type, long tenantId) {
        this.transactionTemplate.execute((TransactionCallback)new StoreConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, bonitaConfigurations, type, tenantId));
    }

    private void cleanAndStoreConfiguration(List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type, long tenantId) {
        this.transactionTemplate.execute((TransactionCallback)new CleanAndStoreConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, bonitaConfigurations, type, tenantId));
    }

    List<BonitaConfiguration> getNonTenantResource(ConfigurationType configurationType) {
        return this.getBonitaConfigurations(configurationType, 0L);
    }

    @Override
    public List<BonitaConfiguration> getTenantEngineConf(long tenantId) {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_ENGINE, tenantId);
    }

    private List<BonitaConfiguration> getBonitaConfigurations(ConfigurationType type, long tenantId) {
        return (List)this.transactionTemplate.execute((TransactionCallback)new GetConfigurationsInTransaction(this.jdbcTemplate, tenantId, type));
    }

    @Override
    public List<BonitaConfiguration> getTenantSecurityScripts(long tenantId) {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_SECURITY_SCRIPTS, tenantId);
    }

    private BonitaConfiguration getBonitaConfiguration(ConfigurationType type, long tenantId, String resourceName) {
        return (BonitaConfiguration)this.transactionTemplate.execute((TransactionCallback)new GetConfigurationInTransaction(this.jdbcTemplate, tenantId, type, resourceName));
    }

    @Override
    public void storeLicenses(File licensesFolder) throws PlatformException {
        Path path = licensesFolder.toPath();
        ArrayList<BonitaConfiguration> bonitaConfigurations = new ArrayList<BonitaConfiguration>();
        LicensesResourceVisitor licensesResourceVisitor = new LicensesResourceVisitor(bonitaConfigurations);
        try {
            Files.walkFileTree(path, licensesResourceVisitor);
            this.cleanAndStoreConfiguration(bonitaConfigurations, ConfigurationType.LICENSES, 0L);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    @Override
    public List<BonitaConfiguration> getLicenses() throws PlatformException {
        return this.getNonTenantResource(ConfigurationType.LICENSES);
    }

    @Override
    public void deleteTenantConfiguration(long tenantId) {
        if (tenantId <= 0L) {
            throw new IllegalArgumentException("tenantId value " + tenantId + " is not allowed");
        }
        this.transactionTemplate.execute((TransactionCallback)new DeleteTenantConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, tenantId));
    }

    @Override
    public void deleteAllConfiguration() {
        this.transactionTemplate.execute((TransactionCallback)new DeleteAllConfigurationInTransaction(this.jdbcTemplate));
    }
}

