/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationResourceVisitor
extends SimpleFileVisitor<Path> {
    private final List<BonitaConfiguration> bonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationResourceVisitor.class);

    public ConfigurationResourceVisitor(List<BonitaConfiguration> bonitaConfigurations) {
        this.bonitaConfigurations = bonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(basicFileAttributes);
        File file = path.toFile();
        if (file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                LOGGER.info("found file " + file.getName());
                this.bonitaConfigurations.add(new BonitaConfiguration(file.getName(), IOUtils.toByteArray((InputStream)fileInputStream)));
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

