/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensesResourceVisitor
extends SimpleFileVisitor<Path> {
    private final List<BonitaConfiguration> bonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicensesResourceVisitor.class);
    private Path dir;

    public LicensesResourceVisitor(List<BonitaConfiguration> bonitaConfigurations) {
        this.bonitaConfigurations = bonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        this.initRootFolder(dir);
        if (this.isSubFolder(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isSubFolder(Path dir) {
        return !this.dir.equals(dir);
    }

    private void initRootFolder(Path dir) {
        if (this.dir == null) {
            this.dir = dir;
        }
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(basicFileAttributes);
        File file = path.toFile();
        if (this.isLicenseFile(file)) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                LOGGER.info("found license file: " + file.getName());
                this.bonitaConfigurations.add(new BonitaConfiguration(file.getName(), IOUtils.toByteArray((InputStream)fileInputStream)));
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isLicenseFile(File file) {
        return file.isFile() && file.getName().endsWith(".lic");
    }
}

