/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.impl.ConfigurationColumns;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.TemporaryLobCreator;

public class BonitaConfigurationPreparedStatementSetter
implements BatchPreparedStatementSetter,
ConfigurationColumns {
    public static final String INSERT_CONFIGURATION = "INSERT into configuration(tenant_id, content_type, resource_name, resource_content) values (?,?,?,?)";
    private final List<BonitaConfiguration> bonitaConfigurations;
    private String dbVendor;
    private ConfigurationType type;
    private long tenantId;

    public BonitaConfigurationPreparedStatementSetter(List<BonitaConfiguration> bonitaConfigurations, String dbVendor, ConfigurationType type, long tenantId) {
        this.bonitaConfigurations = bonitaConfigurations;
        this.dbVendor = dbVendor;
        if (this.dbVendor == null) {
            this.dbVendor = System.getProperty("sysprop.bonita.db.vendor");
        }
        this.type = type;
        this.tenantId = tenantId;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        TemporaryLobCreator temporaryLobCreator = new TemporaryLobCreator();
        BonitaConfiguration bonitaConfiguration = this.bonitaConfigurations.get(i);
        ps.setLong(1, this.tenantId);
        ps.setString(2, this.type.toString());
        ps.setString(3, bonitaConfiguration.getResourceName());
        switch (this.dbVendor) {
            case "h2": 
            case "postgres": {
                ps.setBytes(4, bonitaConfiguration.getResourceContent());
                break;
            }
            case "oracle": 
            case "mysql": 
            case "sqlserver": {
                temporaryLobCreator.setBlobAsBytes(ps, 4, bonitaConfiguration.getResourceContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported db vendor:" + this.dbVendor);
            }
        }
    }

    public int getBatchSize() {
        return this.bonitaConfigurations.size();
    }
}

