/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.bonitasoft.platform.setup.ScriptExecutor;
import org.bonitasoft.platform.version.impl.VersionServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class PlatformSetupAccessor {
    public static PlatformSetup getPlatformSetup() throws NamingException {
        DataSource dataSource = PlatformSetupAccessor.lookupDataSource();
        String dbVendor = System.getProperty("sysprop.bonita.db.vendor");
        return PlatformSetupAccessor.getPlatformSetup(dataSource, dbVendor);
    }

    public static PlatformSetup getPlatformSetup(DataSource dataSource, String dbVendor) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager);
        VersionServiceImpl versionService = new VersionServiceImpl(jdbcTemplate);
        return new PlatformSetup(new ScriptExecutor(dbVendor, dataSource, versionService), new ConfigurationServiceImpl(jdbcTemplate, transactionTemplate, dbVendor), versionService, dataSource);
    }

    private static DataSource lookupDataSource() throws NamingException {
        InitialContext ctx = new InitialContext();
        return (DataSource)ctx.lookup(System.getProperty("sysprop.bonita.database.sequence.manager.datasource.name", "java:comp/env/bonitaSequenceManagerDS"));
    }

    public static ConfigurationService getConfigurationService() throws NamingException {
        DataSource dataSource = PlatformSetupAccessor.lookupDataSource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager);
        return new ConfigurationServiceImpl(jdbcTemplate, transactionTemplate, System.getProperty("sysprop.bonita.db.vendor"));
    }
}

