/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.BundleConfigurator;
import org.bonitasoft.platform.setup.command.configure.DatabaseConfiguration;

class TomcatBundleConfigurator
extends BundleConfigurator {
    private static final String TOMCAT_BACKUP_FOLDER = "tomcat-backups";

    TomcatBundleConfigurator(Path rootPath) throws PlatformException {
        super(rootPath);
    }

    @Override
    protected String getBundleName() {
        return "Tomcat";
    }

    @Override
    public void configureApplicationServer() throws PlatformException {
        this.loadProperties();
        String dbVendor = this.standardConfiguration.getDbVendor();
        String bdmDbVendor = this.bdmConfiguration.getDbVendor();
        Path setEnvUnixFile = this.getPathUnderAppServer("bin/setenv.sh", true);
        Path setEnvWindowsFile = this.getPathUnderAppServer("bin/setenv.bat", true);
        Path bonitaXmlFile = this.getPathUnderAppServer("conf/Catalina/localhost/bonita.xml", true);
        Path bitronixFile = this.getPathUnderAppServer("conf/bitronix-resources.properties", true);
        File bonitaDbDriverFile = this.getDriverFile(dbVendor);
        File bdmDriverFile = this.getDriverFile(bdmDbVendor);
        try {
            this.createBackupFolderIfNecessary("setup/tomcat-backups");
            String newContent = this.readContentFromFile(this.getTemplateFolderPath("setenv.bat"));
            newContent = this.updateSetEnvFile(newContent, dbVendor, "sysprop.bonita.db.vendor");
            newContent = this.updateSetEnvFile(newContent, bdmDbVendor, "sysprop.bonita.bdm.db.vendor");
            this.backupAndReplaceContentIfNecessary(setEnvWindowsFile, newContent, "Setting Bonita BPM internal database vendor to '" + dbVendor + "' and Business Data database vendor to '" + bdmDbVendor + "' in 'setenv.bat' file");
            newContent = this.readContentFromFile(this.getTemplateFolderPath("setenv.sh"));
            newContent = this.updateSetEnvFile(newContent, dbVendor, "sysprop.bonita.db.vendor");
            newContent = this.updateSetEnvFile(newContent, bdmDbVendor, "sysprop.bonita.bdm.db.vendor");
            this.backupAndReplaceContentIfNecessary(setEnvUnixFile, newContent, "Setting Bonita BPM internal database vendor to '" + dbVendor + "' and Business Data database vendor to '" + bdmDbVendor + "' in 'setenv.sh' file");
            newContent = this.readContentFromFile(this.getTemplateFolderPath("bonita.xml"));
            newContent = this.updateBonitaXmlFile(newContent, this.standardConfiguration, "ds1");
            newContent = this.updateBonitaXmlFile(newContent, this.bdmConfiguration, "ds2");
            this.backupAndReplaceContentIfNecessary(bonitaXmlFile, newContent, "Configuring file 'conf/Catalina/localhost/bonita.xml' with your DB values for Bonita BPM internal database on '" + dbVendor + "' and for Business Data database on '" + bdmDbVendor + "'");
            newContent = this.readContentFromFile(this.getTemplateFolderPath("bitronix-resources.properties"));
            newContent = this.updateBitronixFile(newContent, this.standardConfiguration, "ds1");
            newContent = this.updateBitronixFile(newContent, this.bdmConfiguration, "ds2");
            this.backupAndReplaceContentIfNecessary(bitronixFile, newContent, "Configuring file 'conf/bitronix-resources.properties' with your DB values for Bonita BPM internal database on " + dbVendor + " and for Business Data database on " + bdmDbVendor);
            Path srcDriverFile = bonitaDbDriverFile.toPath();
            Path targetBonitaDbDriverFile = this.getPathUnderAppServer("lib/bonita", true).resolve(srcDriverFile.getFileName());
            this.copyDatabaseDriversIfNecessary(srcDriverFile, targetBonitaDbDriverFile, dbVendor);
            Path srcBdmDriverFile = bdmDriverFile.toPath();
            Path targetBdmDriverFile = this.getPathUnderAppServer("lib/bonita", true).resolve(srcBdmDriverFile.getFileName());
            this.copyDatabaseDriversIfNecessary(srcBdmDriverFile, targetBdmDriverFile, bdmDbVendor);
            LOGGER.info("Tomcat auto-configuration complete.");
        }
        catch (PlatformException e) {
            this.restorePreviousConfiguration(setEnvUnixFile, setEnvWindowsFile, bonitaXmlFile, bitronixFile);
            throw e;
        }
    }

    private String updateBitronixFile(String content, DatabaseConfiguration configuration, String bitronixDatasourceAlias) throws PlatformException {
        HashMap<String, String> replacements = new HashMap<String, String>(7);
        replacements.put("@@" + bitronixDatasourceAlias + "_driver_class_name@@", configuration.getXaDriverClassName());
        replacements.put("@@" + bitronixDatasourceAlias + "_database_connection_user@@", configuration.getDatabaseUser());
        replacements.put("@@" + bitronixDatasourceAlias + "_database_connection_password@@", configuration.getDatabasePassword());
        replacements.put("@@" + bitronixDatasourceAlias + "_database_test_query@@", configuration.getTestQuery());
        if ("postgres".equals(configuration.getDbVendor())) {
            replacements.putAll(this.uncommentLineAndReplace("@@" + bitronixDatasourceAlias + "_postgres_server_name@@", configuration.getServerName()));
            replacements.putAll(this.uncommentLineAndReplace("@@" + bitronixDatasourceAlias + "_postgres_port_number@@", configuration.getServerPort()));
            replacements.putAll(this.uncommentLineAndReplace("@@" + bitronixDatasourceAlias + "_postgres_database_name@@", configuration.getDatabaseName()));
        } else {
            replacements.putAll(this.uncommentLineAndReplace("@@" + bitronixDatasourceAlias + "_database_connection_url@@", configuration.getUrl()));
        }
        return this.replaceValues(content, replacements);
    }

    private Map<String, String> uncommentLineAndReplace(String originalValue, String replacement) {
        return Collections.singletonMap("#[ ]*(.*)=" + originalValue, "$1=" + replacement);
    }

    private String updateBonitaXmlFile(String content, DatabaseConfiguration configuration, String bitronixDatasourceAlias) throws PlatformException {
        HashMap<String, String> replacements = new HashMap<String, String>(5);
        replacements.put("@@" + bitronixDatasourceAlias + ".database_connection_user@@", configuration.getDatabaseUser());
        replacements.put("@@" + bitronixDatasourceAlias + ".database_connection_password@@", configuration.getDatabasePassword());
        replacements.put("@@" + bitronixDatasourceAlias + ".driver_class_name@@", configuration.getNonXaDriverClassName());
        replacements.put("@@" + bitronixDatasourceAlias + ".database_connection_url@@", this.escapeXmlCharacters(configuration.getUrl()));
        replacements.put("@@" + bitronixDatasourceAlias + ".database_test_query@@", configuration.getTestQuery());
        return this.replaceValues(content, replacements);
    }

    private String updateSetEnvFile(String setEnvFileContent, String dbVendor, String systemPropertyName) throws PlatformException {
        Map<String, String> replacementMap = Collections.singletonMap("-D" + systemPropertyName + "=.*\"", "-D" + systemPropertyName + "=" + dbVendor + "\"");
        return this.replaceValues(setEnvFileContent, replacementMap);
    }

    void restorePreviousConfiguration(Path setEnvUnixFile, Path setEnvWindowsFile, Path bonitaXmlFile, Path bitronixFile) throws PlatformException {
        LOGGER.warn("Problem encountered, restoring previous configuration");
        this.restoreOriginalFile(bonitaXmlFile);
        this.restoreOriginalFile(bitronixFile);
        this.restoreOriginalFile(setEnvUnixFile);
        this.restoreOriginalFile(setEnvWindowsFile);
    }
}

