/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.TemporaryLobCreator;

public class BonitaConfigurationTenantUpdater
implements BatchPreparedStatementSetter {
    public static final String UPDATE_ALL_TENANTS_CONFIGURATION = "UPDATE configuration SET resource_content=? WHERE content_type=? AND resource_name=?";
    private final List<BonitaConfiguration> bonitaConfigurations;
    private String dbVendor;
    private ConfigurationType type;

    public BonitaConfigurationTenantUpdater(List<BonitaConfiguration> bonitaConfigurations, String dbVendor, ConfigurationType type) {
        this.bonitaConfigurations = bonitaConfigurations;
        this.dbVendor = dbVendor;
        this.type = type;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        BonitaConfiguration bonitaConfiguration = this.bonitaConfigurations.get(i);
        ps.setString(2, this.type.toString());
        ps.setString(3, bonitaConfiguration.getResourceName());
        switch (this.dbVendor) {
            case "h2": 
            case "postgres": {
                ps.setBytes(1, bonitaConfiguration.getResourceContent());
                break;
            }
            case "oracle": 
            case "mysql": 
            case "sqlserver": {
                new TemporaryLobCreator().setBlobAsBytes(ps, 1, bonitaConfiguration.getResourceContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported db vendor:" + this.dbVendor);
            }
        }
    }

    public int getBatchSize() {
        return this.bonitaConfigurations.size();
    }
}

