/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.CommandException;
import org.bonitasoft.platform.setup.command.CommandUtils;
import org.bonitasoft.platform.setup.command.PlatformSetupCommand;

public class HelpCommand
extends PlatformSetupCommand {
    private List<PlatformSetupCommand> commands;

    public HelpCommand() {
        super("help", "Display the help", "Display the help", null);
    }

    @Override
    public void execute(Options options, String ... args) throws PlatformException, CommandException {
        if (args.length == 0) {
            this.printUsage(options);
            throw new CommandException("Need to specify a command, see usage above.");
        }
        if (this.getName().equals(args[0])) {
            if (args.length > 1) {
                this.printHelpFor(options, args[1]);
            } else {
                this.printCommonHelp(options);
            }
        } else {
            this.printUsage(options);
            throw new CommandException("ERROR: no command named: " + args[0]);
        }
    }

    private void printHelpFor(Options options, String commandNameForHelp) throws CommandException {
        PlatformSetupCommand platformSetupCommand = this.getCommand(commandNameForHelp);
        if (platformSetupCommand == null) {
            this.printCommonHelp(options);
            throw new CommandException("ERROR: no command named: " + commandNameForHelp);
        }
        this.printHelpFor(options, platformSetupCommand);
    }

    public void setCommands(List<PlatformSetupCommand> commands) {
        this.commands = commands;
    }

    private PlatformSetupCommand getCommand(String commandName) {
        PlatformSetupCommand command = null;
        for (PlatformSetupCommand platformSetupCommand : this.commands) {
            if (!commandName.equals(platformSetupCommand.getName())) continue;
            command = platformSetupCommand;
            break;
        }
        return command;
    }

    private void printCommonHelp(Options options) {
        this.printUsage(options);
        this.printGlobalHelpHeader();
        this.printCommandsUsage();
        this.printGlobalHelpFooter();
    }

    private void printUsage(Options options) {
        ArrayList<String> names = new ArrayList<String>(this.commands.size());
        for (PlatformSetupCommand command : this.commands) {
            if (command.equals(this)) continue;
            names.add(command.getName());
        }
        String footer = "use `setup help` or `setup help <command>` for more details" + System.lineSeparator();
        this.printUsageFor(options, "( " + StringUtils.join(names.iterator(), (String)" | ") + " )", footer);
    }

    private void printCommandsUsage() {
        StringBuilder usage = new StringBuilder();
        usage.append(System.lineSeparator());
        usage.append("Available commands:").append(System.lineSeparator()).append(System.lineSeparator());
        for (PlatformSetupCommand command : this.commands) {
            usage.append(" ").append(command.getName()).append("  --  ").append(command.getSummary()).append(System.lineSeparator());
        }
        System.out.println(usage.toString());
    }

    private void printHelpFor(Options options, PlatformSetupCommand command) {
        this.printUsageFor(options, command.getName(), System.lineSeparator());
        this.printCommandDescriptionHeader(command);
        this.printCommandUsage(command);
        this.printCommandDescriptionFooter(command);
    }

    private void printCommandDescriptionHeader(PlatformSetupCommand command) {
        if (command.getDescriptionHeader() != null) {
            System.out.println("  " + command.getDescriptionHeader().replace(System.lineSeparator(), System.lineSeparator() + "  "));
        }
    }

    private void printCommandDescriptionFooter(PlatformSetupCommand command) {
        if (command.getDescriptionFooter() != null) {
            System.out.println("  " + command.getDescriptionFooter().replace(System.lineSeparator(), System.lineSeparator() + "  "));
        }
    }

    private void printUsageFor(Options options, String commandName, String footer) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("setup " + commandName, System.lineSeparator() + "Available options:", options, footer, true);
    }

    private void printCommandUsage(PlatformSetupCommand command) {
        System.out.println(System.lineSeparator() + " " + command.getName() + "  --  " + command.getSummary() + System.lineSeparator());
    }

    private void printGlobalHelpHeader() {
        System.out.println(CommandUtils.getFileContentFromClassPath("global_usage_header.txt"));
    }

    private void printGlobalHelpFooter() {
        System.out.println(CommandUtils.getFileContentFromClassPath("global_usage_footer.txt"));
    }
}

