/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.command.configure;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.command.configure.BundleConfigurator;
import org.bonitasoft.platform.setup.command.configure.DatabaseConfiguration;

class WildflyBundleConfigurator
extends BundleConfigurator {
    private static final String WILDFLY_BACKUP_FOLDER = "wildfly-backups";
    private static final String WILDFLY_TEMPLATES_FOLDER = "wildfly-templates";
    private static final Map<String, String> wildflyModules = new HashMap<String, String>(5);

    WildflyBundleConfigurator(Path rootPath) throws PlatformException {
        super(rootPath);
    }

    @Override
    protected String getBundleName() {
        return "Wildfly";
    }

    @Override
    public void configureApplicationServer() throws PlatformException {
        this.loadProperties();
        String dbVendor = this.standardConfiguration.getDbVendor();
        String bdmDbVendor = this.bdmConfiguration.getDbVendor();
        Path standaloneXmlFile = this.getPathUnderAppServer("standalone/configuration/standalone.xml", true);
        File bonitaDbDriverFile = this.getDriverFile(dbVendor);
        File bdmDriverFile = this.getDriverFile(bdmDbVendor);
        try {
            this.createBackupFolderIfNecessary("setup/wildfly-backups");
            String newContent = this.readContentFromFile(this.getPath("setup").resolve(WILDFLY_TEMPLATES_FOLDER).resolve("standalone.xml"));
            newContent = this.updateStandaloneXmlFile(newContent, this.standardConfiguration, "");
            newContent = this.updateStandaloneXmlFile(newContent, this.bdmConfiguration, "BDM_");
            this.backupAndReplaceContentIfNecessary(standaloneXmlFile, newContent, "Configuring file 'standalone/configuration/standalone.xml' with your DB values for Bonita internal database on '" + dbVendor + "' and for Business Data database on '" + bdmDbVendor + "'");
            if (!dbVendor.equals("h2")) {
                Path srcDriverFile = bonitaDbDriverFile.toPath();
                Path moduleFolder = this.getOptionalPathUnderAppServer("modules").resolve(wildflyModules.get(dbVendor)).resolve("main");
                Path targetBonitaDbDriverFile = moduleFolder.resolve(srcDriverFile.getFileName());
                boolean driversCopied = this.copyDatabaseDriversIfNecessary(srcDriverFile, targetBonitaDbDriverFile, dbVendor);
                this.copyDriverModuleFileIfNecessary(targetBonitaDbDriverFile, driversCopied, this.standardConfiguration, moduleFolder);
            }
            if (!bdmDbVendor.equals("h2")) {
                Path srcBdmDriverFile = bdmDriverFile.toPath();
                Path bdmModuleFolder = this.getOptionalPathUnderAppServer("modules").resolve(wildflyModules.get(bdmDbVendor)).resolve("main");
                Path targetBdmDriverFile = bdmModuleFolder.resolve(srcBdmDriverFile.getFileName());
                boolean bdmDriversCopied = this.copyDatabaseDriversIfNecessary(srcBdmDriverFile, targetBdmDriverFile, bdmDbVendor);
                this.copyDriverModuleFileIfNecessary(targetBdmDriverFile, bdmDriversCopied, this.bdmConfiguration, bdmModuleFolder);
            }
            LOGGER.info("Wildfly auto-configuration complete.");
        }
        catch (PlatformException e) {
            this.restorePreviousConfiguration(standaloneXmlFile);
            throw e;
        }
    }

    void restorePreviousConfiguration(Path standaloneXmlFile) throws PlatformException {
        LOGGER.warn("Problem encountered, restoring previous configuration");
        this.restoreOriginalFile(standaloneXmlFile);
    }

    private void copyDriverModuleFileIfNecessary(Path driverFile, boolean driversCopied, DatabaseConfiguration configuration, Path moduleXmlFolder) throws PlatformException {
        if (driversCopied) {
            String moduleFileContent = this.readContentFromFile(this.getPath("setup").resolve(WILDFLY_TEMPLATES_FOLDER).resolve("module.xml"));
            moduleFileContent = this.updateModuleFile(moduleFileContent, configuration, driverFile);
            this.writeContentToFile(moduleXmlFolder.resolve("module.xml"), moduleFileContent);
            LOGGER.info("Creating module.xml file in folder '" + this.getRelativePath(moduleXmlFolder) + "' for " + configuration.getDbVendor());
        }
    }

    private String updateModuleFile(String moduleFileContent, DatabaseConfiguration configuration, Path driverFilename) throws PlatformException {
        HashMap<String, String> replacements = new HashMap<String, String>(2);
        replacements.put("@@MODULE_NAME@@", wildflyModules.get(configuration.getDbVendor()).replaceAll("/", "."));
        replacements.put("@@DRIVERFILE_NAME@@", driverFilename.getFileName().toString());
        return WildflyBundleConfigurator.replaceValues(moduleFileContent, replacements);
    }

    private String updateStandaloneXmlFile(String content, DatabaseConfiguration configuration, String databasePrefix) throws PlatformException {
        HashMap<String, String> replacements = new HashMap<String, String>(12);
        replacements.put("@@" + databasePrefix + "MODULE_NAME@@", wildflyModules.get(configuration.getDbVendor()).replaceAll("/", "."));
        replacements.put("@@" + databasePrefix + "XA_DRIVER_CLASSNAME@@", configuration.getXaDriverClassName());
        if (!this.standardConfiguration.getDbVendor().equals(this.bdmConfiguration.getDbVendor())) {
            replacements.put("<!-- BDM_DRIVER_TEMPLATE (.*) BDM_DRIVER_TEMPLATE -->", "<$1>");
        }
        replacements.put("@@" + databasePrefix + "DB_VENDOR@@", configuration.getDbVendor());
        replacements.put("@@" + databasePrefix + "USERNAME@@", Matcher.quoteReplacement(configuration.getDatabaseUser()));
        replacements.put("@@" + databasePrefix + "PASSWORD@@", Matcher.quoteReplacement(configuration.getDatabasePassword()));
        replacements.put("@@" + databasePrefix + "TESTQUERY@@", configuration.getTestQuery());
        replacements.put("<connection-url>@@" + databasePrefix + "DB_URL@@", "<connection-url>" + WildflyBundleConfigurator.getDatabaseConnectionUrlForXmlFile(configuration));
        if ("postgres".equals(configuration.getDbVendor())) {
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "DB_SERVER_NAME@@", configuration.getServerName()));
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "DB_SERVER_PORT@@", configuration.getServerPort()));
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "DB_DATABASE_NAME@@", Matcher.quoteReplacement(configuration.getDatabaseName())));
        } else {
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "DB_URL@@", WildflyBundleConfigurator.getDatabaseConnectionUrlForXmlFile(configuration)));
        }
        if ("oracle".equals(configuration.getDbVendor())) {
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "IS_SAME_RM_OVERRIDE@@", "false"));
            replacements.putAll(this.uncommentXmlLineAndReplace("@@" + databasePrefix + "NO_TX_SEPARATE_POOL@@", "true"));
        }
        return WildflyBundleConfigurator.replaceValues(content, replacements);
    }

    private Map<String, String> uncommentXmlLineAndReplace(String originalValue, String replacement) {
        return Collections.singletonMap("<!--[ ]*(.*)" + originalValue + "(.*)[ ]*-->", "<$1" + replacement + "$2>");
    }

    static {
        wildflyModules.put("h2", "com/h2database/h2");
        wildflyModules.put("postgres", "org/postgresql");
        wildflyModules.put("oracle", "com/oracle");
        wildflyModules.put("sqlserver", "com/sqlserver");
        wildflyModules.put("mysql", "com/mysql");
    }
}

