/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensesResourceVisitor
extends SimpleFileVisitor<Path> {
    private final List<BonitaConfiguration> bonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicensesResourceVisitor.class);
    private Path dir;

    public LicensesResourceVisitor(List<BonitaConfiguration> bonitaConfigurations) {
        this.bonitaConfigurations = bonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        this.initRootFolder(dir);
        if (this.isSubFolder(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isSubFolder(Path dir) {
        return !this.dir.equals(dir);
    }

    private void initRootFolder(Path dir) {
        if (this.dir == null) {
            this.dir = dir;
        }
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.isLicenseFile(path)) {
            LOGGER.info("found license file: " + path.getFileName());
            this.bonitaConfigurations.add(new BonitaConfiguration(path.getFileName().toString(), Files.readAllBytes(path)));
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isLicenseFile(Path path) {
        return path.getFileName().toString().endsWith(".lic");
    }
}

